/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.api.engine.security.IAuthenticationRoleMapper;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.springframework.context.ApplicationContextException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.object.MappingSqlQuery;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class JdbcUserRoleListService
extends JdbcDaoSupport
implements IUserRoleListService {
    public static final String DEF_ALL_AUTHORITIES_QUERY = "SELECT distinct(authority) as authority FROM authorities";
    public static final String DEF_ALL_USERNAMES_QUERY = "SELECT distinct(username) as username FROM users";
    public static final String DEF_ALL_USERNAMES_IN_ROLE_QUERY = "SELECT distinct(username) as username FROM authorities where authority = ?";
    protected MappingSqlQuery allAuthoritiesMapping;
    protected MappingSqlQuery allUsernamesMapping;
    protected MappingSqlQuery allUsernamesInRoleMapping;
    private String allAuthoritiesQuery = "SELECT distinct(authority) as authority FROM authorities";
    private String allUsernamesQuery = "SELECT distinct(username) as username FROM users";
    private String allUsernamesInRoleQuery = "SELECT distinct(username) as username FROM authorities where authority = ?";
    private UserDetailsService userDetailsService;
    private String rolePrefix;
    private List<String> systemRoles;
    private IAuthenticationRoleMapper roleMapper;

    public JdbcUserRoleListService(UserDetailsService userDetailsService, List<String> systemRoles) {
        this.userDetailsService = userDetailsService;
        this.systemRoles = systemRoles;
    }

    public void setAllAuthoritiesQuery(String queryString) {
        this.allAuthoritiesQuery = queryString;
    }

    public String getAllAuthoritiesQuery() {
        return this.allAuthoritiesQuery;
    }

    public void setAllUsernamesInRoleQuery(String queryString) {
        this.allUsernamesInRoleQuery = queryString;
    }

    public String getAllUsernamesInRoleQuery() {
        return this.allUsernamesInRoleQuery;
    }

    public void setAllUsernamesQuery(String queryString) {
        this.allUsernamesQuery = queryString;
    }

    public String getAllUsernamesQuery() {
        return this.allUsernamesQuery;
    }

    public List<String> getAllRoles() throws DataAccessException {
        List allAuths = this.allAuthoritiesMapping.execute();
        ArrayList<String> roles = new ArrayList<String>(allAuths.size());
        for (GrantedAuthority role : allAuths) {
            if (this.roleMapper != null) {
                roles.add(this.roleMapper.toPentahoRole(role.getAuthority()));
                continue;
            }
            roles.add(role.getAuthority());
        }
        return roles;
    }

    public List<String> getAllUsers() throws DataAccessException {
        List allUserNames = this.allUsernamesMapping.execute();
        return allUserNames;
    }

    public List<String> getUsersInRole(String role) {
        String roleToTest = role;
        if (this.roleMapper != null) {
            roleToTest = this.roleMapper.fromPentahoRole(role);
        }
        List allUserNamesInRole = this.allUsernamesInRoleMapping.execute(roleToTest);
        return allUserNamesInRole;
    }

    protected void initDao() throws ApplicationContextException {
        this.initMappingSqlQueries();
    }

    protected void initMappingSqlQueries() {
        this.allAuthoritiesMapping = new AllAuthoritiesMapping(this.getDataSource());
        this.allUsernamesInRoleMapping = new AllUserNamesInRoleMapping(this.getDataSource());
        this.allUsernamesMapping = new AllUserNamesMapping(this.getDataSource());
    }

    public List<String> getRolesForUser(String username) throws UsernameNotFoundException, DataAccessException {
        UserDetails user = this.userDetailsService.loadUserByUsername(username);
        ArrayList<String> roles = new ArrayList<String>(user.getAuthorities().length);
        for (GrantedAuthority role : user.getAuthorities()) {
            if (this.roleMapper != null) {
                roles.add(this.roleMapper.toPentahoRole(role.getAuthority()));
                continue;
            }
            roles.add(role.getAuthority());
        }
        return roles;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public List<String> getAllRoles(ITenant tenant) {
        if (tenant != null && !tenant.equals(JcrTenantUtils.getDefaultTenant())) {
            throw new UnsupportedOperationException("only allowed to access to default tenant");
        }
        return this.getAllRoles();
    }

    public List<String> getAllUsers(ITenant tenant) {
        if (tenant != null && !tenant.equals(JcrTenantUtils.getDefaultTenant())) {
            throw new UnsupportedOperationException("only allowed to access to default tenant");
        }
        return this.getAllUsers();
    }

    public List<String> getUsersInRole(ITenant tenant, String role) {
        if (tenant != null && !tenant.equals(JcrTenantUtils.getDefaultTenant())) {
            throw new UnsupportedOperationException("only allowed to access to default tenant");
        }
        return this.getUsersInRole(role);
    }

    public List<String> getRolesForUser(ITenant tenant, String username) {
        if (tenant != null && !tenant.equals(JcrTenantUtils.getDefaultTenant())) {
            throw new UnsupportedOperationException("only allowed to access to default tenant");
        }
        return this.getRolesForUser(username);
    }

    public List<String> getSystemRoles() {
        return this.systemRoles;
    }

    public void setRoleMapper(IAuthenticationRoleMapper roleMapper) {
        this.roleMapper = roleMapper;
    }

    protected class AllAuthoritiesMapping
    extends MappingSqlQuery {
        protected AllAuthoritiesMapping(DataSource ds) {
            super(ds, JdbcUserRoleListService.this.allAuthoritiesQuery);
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            return new GrantedAuthorityImpl((null != JdbcUserRoleListService.this.rolePrefix ? JdbcUserRoleListService.this.rolePrefix : "") + rs.getString(1));
        }
    }

    protected class AllUserNamesInRoleMapping
    extends MappingSqlQuery {
        protected AllUserNamesInRoleMapping(DataSource ds) {
            super(ds, JdbcUserRoleListService.this.allUsernamesInRoleQuery);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            return rs.getString(1);
        }
    }

    protected class AllUserNamesMapping
    extends MappingSqlQuery {
        protected AllUserNamesMapping(DataSource ds) {
            super(ds, JdbcUserRoleListService.this.allUsernamesQuery);
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            return rs.getString(1);
        }
    }
}

