/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.web.http.api.resources.FileResource;
import org.pentaho.platform.web.http.api.resources.services.RepositoryPublishService;

@Path(value="/repo/publish")
public class RepositoryPublishResource {
    private static final Log logger = LogFactory.getLog(FileResource.class);
    protected RepositoryPublishService repositoryPublishService = new RepositoryPublishService();

    @POST
    @Path(value="/publishfile")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully publish the artifact."), @ResponseCode(code=403, condition="Failure to publish the file due to permissions."), @ResponseCode(code=500, condition="Failure to publish the file due to a server error.")})
    @Facet(name="Unsupported")
    public Response writeFile(@FormDataParam(value="importPath") String pathId, @FormDataParam(value="fileUpload") InputStream fileContents, @FormDataParam(value="overwriteFile") Boolean overwriteFile, @FormDataParam(value="fileUpload") FormDataContentDisposition fileInfo) {
        try {
            this.repositoryPublishService.writeFile(pathId, fileContents, overwriteFile);
            return this.buildPlainTextOkResponse("SUCCESS");
        }
        catch (PentahoAccessControlException e) {
            return this.buildStatusResponse(Response.Status.UNAUTHORIZED, 5);
        }
        catch (PlatformImportException e) {
            logger.error((Object)e);
            return this.buildStatusResponse(Response.Status.PRECONDITION_FAILED, e.getErrorStatus());
        }
        catch (Exception e) {
            logger.error((Object)e);
            return this.buildServerErrorResponse(2);
        }
    }

    protected Response buildPlainTextOkResponse(String msg) {
        return Response.ok((Object)msg).type("text/plain").build();
    }

    protected Response buildStatusResponse(Response.Status status, int entity) {
        return Response.status((Response.Status)status).entity((Object)Integer.toString(entity)).build();
    }

    protected Response buildServerErrorResponse(int entity) {
        return Response.serverError().entity((Object)Integer.toString(entity)).build();
    }
}

