/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.messages.Messages;

public class GetImage
extends ServletBase {
    private static final long serialVersionUID = 119698153917362988L;
    private static final Log logger = LogFactory.getLog(GetImage.class);

    protected void doGet(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.doPost(arg0, arg1);
    }

    @Override
    public Log getLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            PentahoSystem.systemEntryPoint();
            String image = request.getParameter("image");
            if (image == null) {
                this.error(Messages.getInstance().getErrorString("IMAGE.ERROR_0001_IMAGE_PARAMETER_EMPTY"));
                return;
            }
            this.debug(Messages.getInstance().getString("IMAGE.DEBUG_IMAGE_PARAMETER") + image);
            if (StringUtil.doesPathContainParentPathSegment((String)image)) {
                this.error(Messages.getInstance().getErrorString("IMAGE.ERROR_0002_FILE_NOT_FOUND", new Object[]{image}));
                response.setStatus(404);
                return;
            }
            String location = "";
            location = image.startsWith("/") || image.startsWith("\\") ? "system/tmp/" + image.substring(1) : (image.startsWith("tmp/") || image.startsWith("tmp\\") ? "system/" + image : "system/tmp/" + image);
            File tmpFile = new File(PentahoSystem.getApplicationContext().getSolutionPath(location));
            FileInputStream in = new FileInputStream(tmpFile);
            if (in == null) {
                this.error(Messages.getInstance().getErrorString("IMAGE.ERROR_0002_FILE_NOT_FOUND", new Object[]{image}));
                response.setStatus(404);
                return;
            }
            String mimeType = this.getServletContext().getMimeType(image);
            if (null == mimeType || mimeType.length() <= 0) {
                response.setContentType("image/png");
            } else {
                response.setContentType(mimeType);
            }
            ServletOutputStream out = response.getOutputStream();
            try {
                int n;
                byte[] buffer = new byte[2048];
                int length = 0;
                while ((n = ((InputStream)in).read(buffer)) > 0) {
                    out.write(buffer, 0, n);
                    length += n;
                }
                response.setContentLength(length);
            }
            finally {
                ((InputStream)in).close();
                out.close();
            }
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }
}

