/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import com.sun.xml.ws.transport.http.servlet.SpringBinding;
import com.sun.xml.ws.transport.http.servlet.WSServletDelegate;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class PentahoWSSpringServlet
extends HttpServlet {
    private WSServletDelegate delegate;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.delegate = this.createPluginWSDelegate(servletConfig);
    }

    protected WSServletDelegate createPluginWSDelegate(ServletConfig servletConfig) {
        ApplicationContext appContext = this.getAppContext();
        LinkedHashSet bindings = new LinkedHashSet();
        bindings.addAll(appContext.getBeansOfType(SpringBinding.class).values());
        ServletAdapterList adapters = new ServletAdapterList();
        for (SpringBinding binding : bindings) {
            binding.create(adapters);
        }
        return new WSServletDelegate((List)adapters, this.getServletContext());
    }

    protected ApplicationContext getAppContext() {
        XmlWebApplicationContext wac = new XmlWebApplicationContext(){

            protected Resource getResourceByPath(String path) {
                return new FileSystemResource(new File(path));
            }
        };
        wac.setServletContext(this.getServletContext());
        wac.setServletConfig(this.getServletConfig());
        wac.setNamespace(this.getServletName());
        String springFile = PentahoSystem.getApplicationContext().getSolutionPath("system" + File.separator + "pentahoServices.spring.xml");
        wac.setConfigLocations(new String[]{springFile});
        wac.refresh();
        return wac;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.delegate.doPost(request, response, this.getServletContext());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.delegate.doGet(request, response, this.getServletContext());
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.delegate.doPut(request, response, this.getServletContext());
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.delegate.doDelete(request, response, this.getServletContext());
    }
}

