/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.BundleReader;
import org.apache.jackrabbit.core.persistence.util.BundleReaderSlower;
import org.apache.jackrabbit.core.persistence.util.BundleWriter;
import org.apache.jackrabbit.core.persistence.util.BundleWriterSlower;
import org.apache.jackrabbit.core.persistence.util.ErrorHandling;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.util.StringIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleBinding {
    private static boolean VERIFY_BUNDLES = Boolean.getBoolean("jackrabbit.verifyBundles");
    private static boolean ALLOW_BROKEN_BUNDLES = Boolean.getBoolean("jackrabbit.allowBrokenBundleWrites");
    private static Logger log = LoggerFactory.getLogger(BundleBinding.class);
    static final int BINARY_IN_BLOB_STORE = -1;
    static final int BINARY_IN_DATA_STORE = -2;
    static final NodeId NULL_PARENT_ID;
    static final int VERSION_1 = 1;
    static final int VERSION_2 = 2;
    static final int VERSION_3 = 3;
    static final int VERSION_CURRENT = 3;
    protected final StringIndex nsIndex;
    protected final StringIndex nameIndex;
    protected final BLOBStore blobStore;
    protected long minBlobSize = 16384L;
    protected final ErrorHandling errorHandling;
    protected final DataStore dataStore;

    public BundleBinding(ErrorHandling errorHandling, BLOBStore blobStore, StringIndex nsIndex, StringIndex nameIndex, DataStore dataStore) {
        this.errorHandling = errorHandling;
        this.nsIndex = nsIndex;
        this.nameIndex = nameIndex;
        this.blobStore = blobStore;
        this.dataStore = dataStore;
    }

    public long getMinBlobSize() {
        return this.minBlobSize;
    }

    public void setMinBlobSize(long minBlobSize) {
        this.minBlobSize = minBlobSize;
    }

    public BLOBStore getBlobStore() {
        return this.blobStore;
    }

    public NodePropBundle readBundle(InputStream in, NodeId id) throws IOException {
        if (VERIFY_BUNDLES) {
            return new BundleReaderSlower(this, in).readBundle(id);
        }
        return new BundleReader(this, in).readBundle(id);
    }

    public void writeBundle(OutputStream out, NodePropBundle bundle) throws IOException {
        if (VERIFY_BUNDLES) {
            this.writeBundleSlower(out, bundle);
            return;
        }
        new BundleWriter(this, out).writeBundle(bundle);
    }

    private void writeBundleSlower(OutputStream out, NodePropBundle bundle) throws IOException {
        IOException lastError = null;
        for (int i = 0; i < 5; ++i) {
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            if (i < 3) {
                new BundleWriter(this, buff).writeBundle(bundle);
            } else {
                log.warn("Corrupt bundle: writing slower, i = " + i);
                new BundleWriterSlower(this, buff).writeBundle(bundle);
            }
            byte[] data = buff.toByteArray();
            NodeId id = bundle.getId();
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                new BundleReaderSlower(this, in).readBundleNormal(id);
            }
            catch (IOException e) {
                lastError = e;
                log.warn("Corrupt bundle: could not read the bundle I wrote", (Throwable)e);
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                try {
                    new BundleReader(this, in).readBundle(id);
                    log.warn("Corrupt bundle: can fix error while reading");
                    if (i != 4 || !ALLOW_BROKEN_BUNDLES) continue;
                    log.warn("Corrupt bundle: writing broken one");
                    break;
                }
                catch (IOException e2) {
                    lastError = e2;
                    log.warn("Corrupt bundle: could not read even when trying harder", (Throwable)e2);
                    continue;
                }
            }
            out.write(data);
            return;
        }
        String msg = "Corrupt bundle: could not write a correct bundle, giving up: " + bundle;
        log.error(msg);
        throw new IOException(msg, lastError);
    }

    static {
        if (VERIFY_BUNDLES) {
            log.warn("Please note reading and writing bundles is slightly slower because the system property \"jackrabbit.verifyBundles\" is enabled. See JCR-3652 (patch JCR-3652-b.patch is applied).");
        }
        NULL_PARENT_ID = new NodeId("bb4e9d10-d857-11df-937b-0800200c9a66");
    }
}

