/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.util;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemPathUtil;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.util.ResourceBasedBLOBStore;

public class FileSystemBLOBStore
implements ResourceBasedBLOBStore {
    private final FileSystem fs;

    public FileSystemBLOBStore(FileSystem fs) {
        this.fs = fs;
    }

    public String createId(PropertyId id, int index) {
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        char[] chars = id.getParentId().toString().toCharArray();
        int cnt = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '-') continue;
            if (cnt == 2 || cnt == 4) {
                sb.append('/');
            }
            sb.append(chars[i]);
            ++cnt;
        }
        sb.append('/');
        sb.append(FileSystemPathUtil.escapeName(id.getName().toString()));
        sb.append('.');
        sb.append(index);
        sb.append(".bin");
        return sb.toString();
    }

    public InputStream get(String blobId) throws Exception {
        return this.getResource(blobId).getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String blobId, InputStream in, long size) throws Exception {
        FileSystemResource internalBlobFile = new FileSystemResource(this.fs, blobId);
        internalBlobFile.makeParentDirs();
        OutputStream out = internalBlobFile.getOutputStream();
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    public boolean remove(String blobId) throws Exception {
        FileSystemResource res = new FileSystemResource(this.fs, blobId);
        if (!res.exists()) {
            return false;
        }
        res.delete(true);
        return true;
    }

    public FileSystemResource getResource(String blobId) throws Exception {
        return new FileSystemResource(this.fs, blobId);
    }
}

