/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.core.query.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.ExecutableQuery;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.session.SessionOperation;
import org.apache.jackrabbit.core.stats.RepositoryStatisticsImpl;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
extends AbstractQueryImpl {
    private static final Logger log = LoggerFactory.getLogger(QueryImpl.class);
    protected SessionContext sessionContext;
    protected String statement;
    protected String language;
    protected ExecutableQuery query;
    protected Node node;
    protected QueryHandler handler;
    private boolean initialized = false;
    protected long limit = -1L;
    protected long offset = 0L;

    public void init(SessionContext sessionContext, QueryHandler handler, String statement, String language, Node node) throws InvalidQueryException {
        this.checkNotInitialized();
        this.sessionContext = sessionContext;
        this.statement = statement;
        this.language = language;
        this.handler = handler;
        this.node = node;
        this.query = handler.createExecutableQuery(sessionContext, statement, language);
        this.setInitialized();
    }

    public QueryResult execute() throws RepositoryException {
        this.checkInitialized();
        long time = System.nanoTime();
        QueryResult result = this.sessionContext.getSessionState().perform(new SessionOperation<QueryResult>(){

            @Override
            public QueryResult perform(SessionContext context) throws RepositoryException {
                return QueryImpl.this.query.execute(QueryImpl.this.offset, QueryImpl.this.limit);
            }

            public String toString() {
                return "query.execute(" + QueryImpl.this.statement + ")";
            }
        });
        time = System.nanoTime() - time;
        long timeMs = time / 1000000L;
        log.debug("executed in {} ms. ({})", (Object)timeMs, (Object)this.statement);
        RepositoryStatisticsImpl statistics = this.sessionContext.getRepositoryContext().getRepositoryStatistics();
        statistics.getCounter(RepositoryStatistics.Type.QUERY_COUNT).incrementAndGet();
        statistics.getCounter(RepositoryStatistics.Type.QUERY_DURATION).addAndGet(timeMs);
        this.sessionContext.getRepositoryContext().getStatManager().getQueryStat().logQuery(this.language, this.statement, timeMs);
        return result;
    }

    public String getStatement() {
        this.checkInitialized();
        return this.statement;
    }

    public String getLanguage() {
        this.checkInitialized();
        return this.language;
    }

    public String getStoredQueryPath() throws ItemNotFoundException, RepositoryException {
        this.checkInitialized();
        if (this.node == null) {
            throw new ItemNotFoundException("not a persistent query");
        }
        return this.node.getPath();
    }

    public Node storeAsNode(String absPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        this.checkInitialized();
        try {
            Path p = this.sessionContext.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException(absPath + " is not an absolute path");
            }
            String relPath = this.sessionContext.getJCRPath(p).substring(1);
            Node queryNode = this.sessionContext.getSessionImpl().getRootNode().addNode(relPath, this.sessionContext.getJCRName(NameConstants.NT_QUERY));
            queryNode.setProperty(this.sessionContext.getJCRName(NameConstants.JCR_LANGUAGE), this.language);
            queryNode.setProperty(this.sessionContext.getJCRName(NameConstants.JCR_STATEMENT), this.statement);
            this.node = queryNode;
            return this.node;
        }
        catch (NameException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public String[] getBindVariableNames() {
        return new String[0];
    }

    public void bindValue(String varName, Value value) throws IllegalArgumentException {
        throw new IllegalArgumentException("No such bind variable: " + varName);
    }

    public void setLimit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("limit must not be negative");
        }
        this.limit = limit;
    }

    public void setOffset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset must not be negative");
        }
        this.offset = offset;
    }

    protected void setInitialized() {
        this.initialized = true;
    }

    protected void checkNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
    }
}

