/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.lucene.ChildNodesQueryHits;
import org.apache.jackrabbit.core.query.lucene.DescendantSelfAxisQuery;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.FieldSelectors;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.JackrabbitIndexSearcher;
import org.apache.jackrabbit.core.query.lucene.JackrabbitQuery;
import org.apache.jackrabbit.core.query.lucene.MatchAllDocsQuery;
import org.apache.jackrabbit.core.query.lucene.NameQuery;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.QueryHits;
import org.apache.jackrabbit.core.query.lucene.TermFactory;
import org.apache.jackrabbit.core.query.lucene.hits.AbstractHitCollector;
import org.apache.jackrabbit.core.query.lucene.hits.AdaptingHits;
import org.apache.jackrabbit.core.query.lucene.hits.Hits;
import org.apache.jackrabbit.core.query.lucene.hits.ScorerHits;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.Weight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChildAxisQuery
extends Query
implements JackrabbitQuery {
    private static final Logger log = LoggerFactory.getLogger(ChildAxisQuery.class);
    private static int CONTEXT_SIZE_THRESHOLD = 10;
    private final ItemStateManager itemMgr;
    private Query contextQuery;
    private final Name nameTest;
    private final int position;
    private final IndexFormatVersion version;
    private final NamespaceMappings nsMappings;
    private Scorer contextScorer;
    private Scorer nameTestScorer;

    ChildAxisQuery(ItemStateManager itemMgr, Query context, Name nameTest, IndexFormatVersion version, NamespaceMappings nsMappings) {
        this(itemMgr, context, nameTest, -2147483647, version, nsMappings);
    }

    ChildAxisQuery(ItemStateManager itemMgr, Query context, Name nameTest, int position, IndexFormatVersion version, NamespaceMappings nsMapping) {
        this.itemMgr = itemMgr;
        this.contextQuery = context;
        this.nameTest = nameTest;
        this.position = position;
        this.version = version;
        this.nsMappings = nsMapping;
    }

    Query getContextQuery() {
        return this.contextQuery;
    }

    boolean matchesAnyChildNode() {
        return this.nameTest == null && this.position == -2147483647;
    }

    Name getNameTest() {
        return this.nameTest;
    }

    int getPosition() {
        return this.position;
    }

    public Weight createWeight(Searcher searcher) {
        return new ChildAxisWeight(searcher);
    }

    public void extractTerms(Set<Term> terms) {
        this.contextQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        DescendantSelfAxisQuery dsaq;
        Query cQuery = this.contextQuery.rewrite(reader);
        if (this.position == -2147483647 && cQuery instanceof DescendantSelfAxisQuery && (dsaq = (DescendantSelfAxisQuery)cQuery).subQueryMatchesAll()) {
            Object sub = this.nameTest == null ? new MatchAllDocsQuery() : new NameQuery(this.nameTest, this.version, this.nsMappings);
            return new DescendantSelfAxisQuery(dsaq.getContextQuery(), (Query)sub, dsaq.getMinLevels() + 1).rewrite(reader);
        }
        if (cQuery == this.contextQuery) {
            return this;
        }
        return new ChildAxisQuery(this.itemMgr, cQuery, this.nameTest, this.position, this.version, this.nsMappings);
    }

    public String toString(String field) {
        StringBuffer sb = new StringBuffer();
        sb.append("ChildAxisQuery(");
        sb.append(this.contextQuery);
        sb.append(", ");
        sb.append(this.nameTest);
        if (this.position != -2147483647) {
            sb.append(", ");
            sb.append(this.position);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public QueryHits execute(JackrabbitIndexSearcher searcher, SessionImpl session, Sort sort) throws IOException {
        if (sort.getSort().length == 0 && this.matchesAnyChildNode()) {
            Query context = this.getContextQuery();
            return new ChildNodesQueryHits(searcher.evaluate(context), session);
        }
        return null;
    }

    private final class HierarchyResolvingChildrenCalculator
    extends ChildrenCalculator {
        private final Set<Integer> docIds;

        public HierarchyResolvingChildrenCalculator(IndexReader reader, HierarchyResolver hResolver) {
            super(reader, hResolver);
            this.docIds = new HashSet<Integer>();
        }

        protected void collectContextHit(int doc) {
            this.docIds.add(doc);
        }

        public Hits getHits() throws IOException {
            long time = System.currentTimeMillis();
            AdaptingHits childrenHits = new AdaptingHits();
            ScorerHits nameHits = new ScorerHits(ChildAxisQuery.this.nameTestScorer);
            int[] docs = new int[1];
            int h = nameHits.next();
            while (h > -1) {
                if ((docs = this.hResolver.getParents(h, docs)).length == 1) {
                    if (this.docIds.contains(docs[0])) {
                        childrenHits.set(h);
                    }
                } else {
                    for (int i = 0; i < docs.length; ++i) {
                        if (!this.docIds.contains(docs[i])) continue;
                        childrenHits.set(h);
                    }
                }
                h = nameHits.next();
            }
            time = System.currentTimeMillis() - time;
            log.debug("Filtered hits in {} ms.", (Object)time);
            return childrenHits;
        }
    }

    private final class SimpleChildrenCalculator
    extends ChildrenCalculator {
        private final Hits contextHits;

        public SimpleChildrenCalculator(IndexReader reader, HierarchyResolver hResolver) {
            super(reader, hResolver);
            this.contextHits = new AdaptingHits();
        }

        protected void collectContextHit(int doc) {
            this.contextHits.set(doc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Hits getHits() throws IOException {
            HashMap<Integer, String> uuids = new HashMap<Integer, String>();
            int i = this.contextHits.next();
            while (i > -1) {
                String uuid = this.reader.document(i, FieldSelectors.UUID).get(FieldNames.UUID);
                uuids.put(i, uuid);
                i = this.contextHits.next();
            }
            AdaptingHits childrenHits = new AdaptingHits();
            for (String uuid : uuids.values()) {
                NodeId id = new NodeId(uuid);
                try {
                    long time = System.currentTimeMillis();
                    NodeState state = (NodeState)ChildAxisQuery.this.itemMgr.getItemState(id);
                    time = System.currentTimeMillis() - time;
                    log.debug("got NodeState with id {} in {} ms.", (Object)id, (Object)time);
                    List<ChildNodeEntry> entries = ChildAxisQuery.this.nameTest != null ? state.getChildNodeEntries(ChildAxisQuery.this.nameTest) : state.getChildNodeEntries();
                    for (ChildNodeEntry entry : entries) {
                        NodeId childId = entry.getId();
                        Term uuidTerm = TermFactory.createUUIDTerm(childId.toString());
                        TermDocs docs = this.reader.termDocs(uuidTerm);
                        try {
                            if (!docs.next()) continue;
                            childrenHits.set(docs.doc());
                        }
                        finally {
                            docs.close();
                        }
                    }
                }
                catch (ItemStateException e) {
                }
            }
            return childrenHits;
        }
    }

    private abstract class ChildrenCalculator {
        protected final IndexReader reader;
        protected final HierarchyResolver hResolver;

        public ChildrenCalculator(IndexReader reader, HierarchyResolver hResolver) {
            this.reader = reader;
            this.hResolver = hResolver;
        }

        protected abstract void collectContextHit(int var1);

        public abstract Hits getHits() throws IOException;
    }

    private class ChildAxisScorer
    extends Scorer {
        private final IndexReader reader;
        private final HierarchyResolver hResolver;
        private int nextDoc;
        private Hits hits;

        protected ChildAxisScorer(Similarity similarity, IndexReader reader, HierarchyResolver hResolver) {
            super(similarity);
            this.nextDoc = -1;
            this.reader = reader;
            this.hResolver = hResolver;
        }

        public int nextDoc() throws IOException {
            if (this.nextDoc == Integer.MAX_VALUE) {
                return this.nextDoc;
            }
            this.calculateChildren();
            do {
                this.nextDoc = this.hits.next();
            } while (this.nextDoc > -1 && !this.indexIsValid(this.nextDoc));
            if (this.nextDoc < 0) {
                this.nextDoc = Integer.MAX_VALUE;
            }
            return this.nextDoc;
        }

        public int docID() {
            return this.nextDoc;
        }

        public float score() throws IOException {
            return 1.0f;
        }

        public int advance(int target) throws IOException {
            if (this.nextDoc == Integer.MAX_VALUE) {
                return this.nextDoc;
            }
            if (target == Integer.MAX_VALUE) {
                this.hits.skipTo(target);
                this.nextDoc = Integer.MAX_VALUE;
                return this.nextDoc;
            }
            this.calculateChildren();
            this.nextDoc = this.hits.skipTo(target);
            while (this.nextDoc > -1 && !this.indexIsValid(this.nextDoc)) {
                this.nextDoc();
            }
            if (this.nextDoc < 0) {
                this.nextDoc = Integer.MAX_VALUE;
            }
            return this.nextDoc;
        }

        private void calculateChildren() throws IOException {
            if (this.hits == null) {
                final ChildrenCalculator[] calc = new ChildrenCalculator[1];
                if (ChildAxisQuery.this.nameTestScorer == null) {
                    calc[0] = new SimpleChildrenCalculator(this.reader, this.hResolver);
                    ChildAxisQuery.this.contextScorer.score((Collector)new AbstractHitCollector(){

                        protected void collect(int doc, float score) {
                            calc[0].collectContextHit(doc);
                        }
                    });
                } else {
                    calc[0] = new SimpleChildrenCalculator(this.reader, this.hResolver);
                    ChildAxisQuery.this.contextScorer.score((Collector)new AbstractHitCollector(){
                        private List<Integer> docIds = new ArrayList<Integer>();

                        protected void collect(int doc, float score) {
                            calc[0].collectContextHit(doc);
                            if (this.docIds != null) {
                                this.docIds.add(doc);
                                if (this.docIds.size() > CONTEXT_SIZE_THRESHOLD) {
                                    calc[0] = new HierarchyResolvingChildrenCalculator(ChildAxisScorer.this.reader, ChildAxisScorer.this.hResolver);
                                    for (int docId : this.docIds) {
                                        calc[0].collectContextHit(docId);
                                    }
                                    this.docIds = null;
                                }
                            }
                        }
                    });
                }
                this.hits = calc[0].getHits();
            }
        }

        private boolean indexIsValid(int i) throws IOException {
            if (ChildAxisQuery.this.position != -2147483647) {
                Document node = this.reader.document(i, FieldSelectors.UUID_AND_PARENT);
                NodeId parentId = NodeId.valueOf(node.get(FieldNames.PARENT));
                NodeId id = NodeId.valueOf(node.get(FieldNames.UUID));
                try {
                    NodeState state = (NodeState)ChildAxisQuery.this.itemMgr.getItemState(parentId);
                    if (ChildAxisQuery.this.nameTest == null) {
                        List<ChildNodeEntry> childNodes = state.getChildNodeEntries();
                        if (ChildAxisQuery.this.position == Integer.MIN_VALUE ? childNodes.size() == 0 || !childNodes.get(childNodes.size() - 1).getId().equals(id) : ChildAxisQuery.this.position < 1 || childNodes.size() < ChildAxisQuery.this.position || !childNodes.get(ChildAxisQuery.this.position - 1).getId().equals(id)) {
                            return false;
                        }
                    } else if (ChildAxisQuery.this.position == Integer.MIN_VALUE) {
                        ChildNodeEntry entry = state.getChildNodeEntry(id);
                        if (entry == null) {
                            return false;
                        }
                        Name name = entry.getName();
                        List<ChildNodeEntry> childNodes = state.getChildNodeEntries(name);
                        if (childNodes.size() == 0 || !childNodes.get(childNodes.size() - 1).getId().equals(id)) {
                            return false;
                        }
                    } else {
                        ChildNodeEntry entry = state.getChildNodeEntry(id);
                        if (entry == null) {
                            return false;
                        }
                        if (entry.getIndex() != ChildAxisQuery.this.position) {
                            return false;
                        }
                    }
                }
                catch (ItemStateException e) {
                    return false;
                }
            }
            return true;
        }
    }

    private class ChildAxisWeight
    extends Weight {
        private final Searcher searcher;

        private ChildAxisWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return ChildAxisQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            ChildAxisQuery.this.contextScorer = ChildAxisQuery.this.contextQuery.weight(this.searcher).scorer(reader, scoreDocsInOrder, topScorer);
            if (ChildAxisQuery.this.nameTest != null) {
                ChildAxisQuery.this.nameTestScorer = new NameQuery(ChildAxisQuery.this.nameTest, ChildAxisQuery.this.version, ChildAxisQuery.this.nsMappings).weight(this.searcher).scorer(reader, scoreDocsInOrder, topScorer);
            }
            return new ChildAxisScorer(this.searcher.getSimilarity(), reader, (HierarchyResolver)reader);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

