/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.sort;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.qom.Operand;
import javax.jcr.query.qom.Ordering;
import org.apache.jackrabbit.commons.query.qom.OperandEvaluator;
import org.apache.jackrabbit.core.query.lucene.sort.AbstractFieldComparator;
import org.apache.jackrabbit.core.query.lucene.sort.ValueComparableWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DynamicOperandFieldComparator
extends AbstractFieldComparator {
    private final Session session;
    private final OperandEvaluator evaluator;
    private final Ordering ordering;

    public DynamicOperandFieldComparator(Session session, OperandEvaluator evaluator, Ordering ordering, int numHits) {
        super(numHits);
        this.session = session;
        this.evaluator = evaluator;
        this.ordering = ordering;
    }

    protected Comparable<ValueComparableWrapper> sortValue(int doc) {
        try {
            String uuid = this.getUUIDForIndex(doc);
            Node n = this.session.getNodeByIdentifier(uuid);
            Value[] v = this.evaluator.getValues((Operand)this.ordering.getOperand(), n);
            return new ValueComparableWrapper(v);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

