/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.cache.GrowingLRUMap;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.security.authorization.AccessControlModifications;
import org.apache.jackrabbit.core.security.authorization.acl.ACLProvider;
import org.apache.jackrabbit.core.security.authorization.acl.EntryCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachingEntryCollector
extends EntryCollector {
    private static final Logger log = LoggerFactory.getLogger(CachingEntryCollector.class);
    private final Map<NodeId, EntryCollector.Entries> cache;
    private final Object monitor = new Object();

    CachingEntryCollector(SessionImpl systemSession, NodeId rootID) throws RepositoryException {
        super(systemSession, rootID);
        int maxsize = 5000;
        String propname = "org.apache.jackrabbit.core.security.authorization.acl.CachingEntryCollector.maxsize";
        try {
            maxsize = Integer.parseInt(System.getProperty(propname, Integer.toString(maxsize)));
        }
        catch (NumberFormatException ex) {
            log.error("Parsing system property " + propname + " with value: " + System.getProperty(propname), (Throwable)ex);
        }
        log.info("Creating cache with max size of: " + maxsize);
        this.cache = new GrowingLRUMap(1024, maxsize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        super.close();
        Object object = this.monitor;
        synchronized (object) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntryCollector.Entries getEntries(NodeImpl node) throws RepositoryException {
        EntryCollector.Entries entries;
        NodeId nodeId = node.getNodeId();
        Object object = this.monitor;
        synchronized (object) {
            entries = this.cache.get(nodeId);
            if (entries == null) {
                entries = this.updateCache(node);
            } else {
                log.debug("Cache hit for nodeId {}", (Object)nodeId);
            }
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntryCollector.Entries getEntries(NodeId nodeId) throws RepositoryException {
        EntryCollector.Entries entries;
        Object object = this.monitor;
        synchronized (object) {
            entries = this.cache.get(nodeId);
            if (entries == null) {
                NodeImpl n = this.getNodeById(nodeId);
                entries = this.updateCache(n);
            } else {
                log.debug("Cache hit for nodeId {}", (Object)nodeId);
            }
        }
        return entries;
    }

    private EntryCollector.Entries updateCache(NodeImpl node) throws RepositoryException {
        EntryCollector.Entries entries = super.getEntries(node);
        if (!entries.isEmpty()) {
            NodeId nextId = null;
            NodeImpl n = node;
            while (nextId == null && !this.rootID.equals(n.getNodeId())) {
                if (this.cache.containsKey(n.getNodeId())) {
                    nextId = n.getNodeId();
                    continue;
                }
                if (this.cache.containsKey(n.getParentId())) {
                    nextId = n.getParentId();
                    continue;
                }
                if (!CachingEntryCollector.hasEntries(n = (NodeImpl)n.getParent())) continue;
                nextId = n.getNodeId();
            }
            entries.setNextId(nextId);
            this.cache.put(node.getNodeId(), entries);
            log.debug("Update cache for node {}: {}", (Object)node, (Object)entries);
        }
        return entries;
    }

    private static boolean hasEntries(NodeImpl n) throws RepositoryException {
        if (ACLProvider.isAccessControlled(n)) {
            NodeImpl aclNode = n.getNode(N_POLICY);
            return aclNode.hasNodes();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(AccessControlModifications modifications) {
        for (Object key : modifications.getNodeIdentifiers()) {
            if (!(key instanceof NodeId)) {
                log.warn("Cannot process AC modificationMap entry. Keys must be NodeId.");
                continue;
            }
            NodeId nodeId = (NodeId)key;
            int type = modifications.getType(nodeId);
            Object object = this.monitor;
            synchronized (object) {
                if ((type & 1) == 1) {
                    log.debug("Policy added, clearing the cache");
                    this.cache.clear();
                    break;
                }
                if ((type & 2) == 2) {
                    EntryCollector.Entries ce = this.cache.remove(nodeId);
                    if (ce != null) {
                        NodeId nextId = ce.getNextId();
                        for (EntryCollector.Entries entry : this.cache.values()) {
                            if (!nodeId.equals(entry.getNextId())) continue;
                            entry.setNextId(nextId);
                        }
                    }
                } else if ((type & 4) == 4) {
                    this.cache.remove(nodeId);
                } else if ((type & 8) == 8) {
                    log.debug("Move operation, clearing the cache");
                    this.cache.clear();
                    break;
                }
            }
        }
        super.notifyListeners(modifications);
    }
}

