/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.ServiceException;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.ICLIService;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.log.OperationLog;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.SessionManager;

public class CLIService
extends CompositeService
implements ICLIService {
    private final Log LOG = LogFactory.getLog((String)CLIService.class.getName());
    private HiveConf hiveConf;
    private SessionManager sessionManager;
    private IMetaStoreClient metastoreClient;
    private String serverUserName = null;

    public CLIService() {
        super("CLIService");
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        this.sessionManager = new SessionManager();
        this.addService(this.sessionManager);
        try {
            HiveAuthFactory.loginFromKeytab(hiveConf);
            this.serverUserName = ShimLoader.getHadoopShims().getShortUserName(ShimLoader.getHadoopShims().getUGIForConf((Configuration)hiveConf));
        }
        catch (IOException e) {
            throw new ServiceException("Unable to login to kerberos with given principal/keytab", e);
        }
        catch (LoginException e) {
            throw new ServiceException("Unable to login to kerberos with given principal/keytab", e);
        }
        super.init(hiveConf);
    }

    @Override
    public synchronized void start() {
        super.start();
        try {
            this.metastoreClient = new HiveMetaStoreClient(this.hiveConf);
            this.metastoreClient.getDatabases("default");
        }
        catch (Exception e) {
            throw new ServiceException("Unable to connect to MetaStore!", e);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.metastoreClient != null) {
            this.metastoreClient.close();
        }
        super.stop();
    }

    @Override
    public SessionHandle openSession(String username, String password, Map<String, String> configuration) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(username, password, configuration, false, null);
        this.LOG.info((Object)(sessionHandle + ": openSession()"));
        this.sessionManager.clearThreadLocals();
        return sessionHandle;
    }

    @Override
    public SessionHandle openSessionWithImpersonation(String username, String password, Map<String, String> configuration, String delegationToken) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(username, password, configuration, true, delegationToken);
        this.LOG.info((Object)(sessionHandle + ": openSessionWithImpersonation()"));
        this.sessionManager.clearThreadLocals();
        return sessionHandle;
    }

    @Override
    public void closeSession(SessionHandle sessionHandle) throws HiveSQLException {
        this.sessionManager.closeSession(sessionHandle);
        this.LOG.info((Object)(sessionHandle + ": closeSession()"));
        this.sessionManager.clearThreadLocals();
    }

    @Override
    public GetInfoValue getInfo(SessionHandle sessionHandle, GetInfoType getInfoType) throws HiveSQLException {
        GetInfoValue infoValue = this.sessionManager.getSession(sessionHandle).getInfo(getInfoType);
        this.LOG.info((Object)(sessionHandle + ": getInfo()"));
        this.sessionManager.clearThreadLocals();
        return infoValue;
    }

    @Override
    public OperationHandle executeStatement(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).executeStatement(statement, confOverlay);
        this.LOG.info((Object)(sessionHandle + ": executeStatement()"));
        this.sessionManager.clearThreadLocals();
        return opHandle;
    }

    @Override
    public OperationHandle getTypeInfo(SessionHandle sessionHandle) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getTypeInfo();
        this.LOG.info((Object)(sessionHandle + ": getTypeInfo()"));
        this.sessionManager.clearThreadLocals();
        return opHandle;
    }

    @Override
    public OperationHandle getCatalogs(SessionHandle sessionHandle) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getCatalogs();
        this.LOG.info((Object)(sessionHandle + ": getCatalogs()"));
        this.sessionManager.clearThreadLocals();
        return opHandle;
    }

    @Override
    public OperationHandle getSchemas(SessionHandle sessionHandle, String catalogName, String schemaName) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getSchemas(catalogName, schemaName);
        this.LOG.info((Object)(sessionHandle + ": getSchemas()"));
        this.sessionManager.clearThreadLocals();
        return opHandle;
    }

    @Override
    public OperationHandle getTables(SessionHandle sessionHandle, String catalogName, String schemaName, String tableName, List<String> tableTypes) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getTables(catalogName, schemaName, tableName, tableTypes);
        this.LOG.info((Object)(sessionHandle + ": getTables()"));
        this.sessionManager.clearThreadLocals();
        return opHandle;
    }

    @Override
    public OperationHandle getTableTypes(SessionHandle sessionHandle) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getTableTypes();
        this.LOG.info((Object)(sessionHandle + ": getTableTypes()"));
        this.sessionManager.clearThreadLocals();
        return opHandle;
    }

    @Override
    public OperationHandle getColumns(SessionHandle sessionHandle, String catalogName, String schemaName, String tableName, String columnName) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getColumns(catalogName, schemaName, tableName, columnName);
        this.LOG.info((Object)(sessionHandle + ": getColumns()"));
        this.sessionManager.clearThreadLocals();
        return opHandle;
    }

    @Override
    public OperationHandle getFunctions(SessionHandle sessionHandle, String catalogName, String schemaName, String functionName) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getFunctions(catalogName, schemaName, functionName);
        this.LOG.info((Object)(sessionHandle + ": getFunctions()"));
        this.sessionManager.clearThreadLocals();
        return opHandle;
    }

    @Override
    public OperationState getOperationStatus(OperationHandle opHandle) throws HiveSQLException {
        this.startLogCapture(opHandle);
        OperationState opState = this.sessionManager.getOperationManager().getOperationState(opHandle);
        this.LOG.info((Object)(opHandle + ": getOperationStatus()"));
        this.sessionManager.clearThreadLocals();
        this.stopLogCapture();
        return opState;
    }

    @Override
    public void cancelOperation(OperationHandle opHandle) throws HiveSQLException {
        this.startLogCapture(opHandle);
        this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().cancelOperation(opHandle);
        this.LOG.info((Object)(opHandle + ": cancelOperation()"));
        this.sessionManager.clearThreadLocals();
        this.stopLogCapture();
    }

    @Override
    public void closeOperation(OperationHandle opHandle) throws HiveSQLException {
        this.startLogCapture(opHandle);
        this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().closeOperation(opHandle);
        this.LOG.info((Object)(opHandle + ": closeOperation"));
        this.sessionManager.clearThreadLocals();
        this.sessionManager.getLogManager().destroyOperationLog(opHandle);
        this.stopLogCapture();
    }

    @Override
    public TableSchema getResultSetMetadata(OperationHandle opHandle) throws HiveSQLException {
        this.startLogCapture(opHandle);
        TableSchema tableSchema = this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().getResultSetMetadata(opHandle);
        this.LOG.info((Object)(opHandle + ": getResultSetMetadata()"));
        this.sessionManager.clearThreadLocals();
        this.stopLogCapture();
        return tableSchema;
    }

    @Override
    public RowSet fetchResults(OperationHandle opHandle, FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.startLogCapture(opHandle);
        RowSet rowSet = this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().fetchResults(opHandle, orientation, maxRows);
        this.LOG.info((Object)(opHandle + ": fetchResults()"));
        this.sessionManager.clearThreadLocals();
        this.stopLogCapture();
        return rowSet;
    }

    @Override
    public RowSet fetchResults(OperationHandle opHandle) throws HiveSQLException {
        this.startLogCapture(opHandle);
        RowSet rowSet = this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().fetchResults(opHandle);
        this.LOG.info((Object)(opHandle + ": fetchResults()"));
        this.sessionManager.clearThreadLocals();
        this.stopLogCapture();
        return rowSet;
    }

    public void setIpAddress(SessionHandle sessionHandle, String ipAddress) {
        try {
            HiveSession session = this.sessionManager.getSession(sessionHandle);
            session.setIpAddress(ipAddress);
        }
        catch (HiveSQLException e) {
            this.LOG.error((Object)"Unable to get session to set ipAddress", (Throwable)e);
        }
    }

    public void setUserName(SessionHandle sessionHandle, String userName) {
        try {
            HiveSession session = this.sessionManager.getSession(sessionHandle);
            session.setUserName(userName);
            SessionManager.setUserName(userName);
        }
        catch (HiveSQLException e) {
            this.LOG.error((Object)"Unable to set userName in sessions", (Throwable)e);
        }
    }

    public synchronized String getDelegationTokenFromMetaStore(String owner) throws HiveSQLException, UnsupportedOperationException, LoginException, IOException {
        if (!this.hiveConf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL) || !this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_IMPERSONATION)) {
            throw new UnsupportedOperationException("delegation token is can only be obtained for a secure remote metastore");
        }
        try {
            Hive.closeCurrent();
            return Hive.get((HiveConf)this.hiveConf).getDelegationToken(owner, owner);
        }
        catch (HiveException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                throw (UnsupportedOperationException)e.getCause();
            }
            throw new HiveSQLException("Error connect metastore to setup impersonation", e);
        }
    }

    @Override
    public String getLog(OperationHandle opHandle) throws HiveSQLException {
        OperationLog log = this.sessionManager.getLogManager().getOperationLogByOperation(opHandle, false);
        this.LOG.info((Object)(opHandle + ": getLog()"));
        this.sessionManager.clearThreadLocals();
        return log.readOperationLog();
    }

    private void startLogCapture(OperationHandle operationHandle) throws HiveSQLException {
        this.sessionManager.getLogManager().unregisterCurrentThread();
        this.sessionManager.getLogManager().registerCurrentThread(operationHandle);
    }

    private void stopLogCapture() {
        this.sessionManager.getLogManager().unregisterCurrentThread();
    }

    @Override
    public String getDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String owner, String renewer) throws HiveSQLException {
        String delegationToken = this.sessionManager.getSession(sessionHandle).getDelegationToken(authFactory, owner, renewer);
        this.LOG.info((Object)(sessionHandle + ": getDelegationToken()"));
        this.sessionManager.clearThreadLocals();
        return delegationToken;
    }

    @Override
    public void cancelDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        this.sessionManager.getSession(sessionHandle).cancelDelegationToken(authFactory, tokenStr);
        this.LOG.info((Object)(sessionHandle + ": cancelDelegationToken()"));
        this.sessionManager.clearThreadLocals();
    }

    @Override
    public void renewDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        this.sessionManager.getSession(sessionHandle).renewDelegationToken(authFactory, tokenStr);
        this.LOG.info((Object)(sessionHandle + ": renewDelegationToken()"));
        this.sessionManager.clearThreadLocals();
    }
}

