/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.EnumSet;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.MetadataOperation;
import org.apache.hive.service.cli.session.HiveSession;

public class GetCatalogsOperation
extends MetadataOperation {
    private static final TableSchema RESULT_SET_SCHEMA = new TableSchema().addStringColumn("TABLE_CAT", "Catalog name. NULL if not applicable.");
    private final RowSet rowSet = new RowSet();

    protected GetCatalogsOperation(HiveSession parentSession) {
        super(parentSession, OperationType.GET_CATALOGS);
    }

    @Override
    public void run() throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        this.setState(OperationState.FINISHED);
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        return RESULT_SET_SCHEMA;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.assertState(OperationState.FINISHED);
        this.validateFetchOrientation(orientation, EnumSet.of(FetchOrientation.FETCH_NEXT, FetchOrientation.FETCH_FIRST));
        if (orientation.equals((Object)FetchOrientation.FETCH_FIRST)) {
            this.rowSet.setStartOffset(0L);
        }
        return this.rowSet.extractSubset((int)maxRows);
    }
}

