/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.log.LogManager;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.HiveSessionHook;
import org.apache.hive.service.cli.session.HiveSessionHookContextImpl;
import org.apache.hive.service.cli.session.HiveSessionImpl;
import org.apache.hive.service.cli.session.HiveSessionImplwithUGI;
import org.apache.hive.service.cli.session.HiveSessionProxy;

public class SessionManager
extends CompositeService {
    private static final int SESSION_CHECK_INTERVAL = 60000;
    private static final Log LOG = LogFactory.getLog(CompositeService.class);
    private HiveConf hiveConf;
    private final Map<SessionHandle, HiveSession> handleToSession = new HashMap<SessionHandle, HiveSession>();
    private OperationManager operationManager = new OperationManager();
    private LogManager logManager = new LogManager();
    private static final Object sessionMapLock = new Object();
    private Thread timeoutChecker;
    private long checkInterval;
    private long sessionTimeout;
    private volatile boolean shutdown;
    private static ThreadLocal<String> threadLocalIpAddress = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };
    private static ThreadLocal<String> threadLocalUserName = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return null;
        }
    };

    public SessionManager() {
        super("SessionManager");
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        this.operationManager = new OperationManager();
        this.operationManager.setSessionManager(this);
        this.checkInterval = HiveConf.getTimeInMsec((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_SESSION_CHECK_INTERVAL);
        this.sessionTimeout = HiveConf.getTimeInMsec((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_IDLE_SESSION_TIMEOUT);
        this.addService(this.operationManager);
        this.logManager = new LogManager();
        this.logManager.setSessionManager(this);
        this.addService(this.logManager);
        super.init(hiveConf);
    }

    @Override
    public synchronized void start() {
        super.start();
        if (this.checkInterval <= 0L) {
            return;
        }
        final long interval = Math.max(this.checkInterval, TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS));
        this.timeoutChecker = new Thread(new Runnable(){

            @Override
            public void run() {
                this.sleepInterval(interval);
                while (!SessionManager.this.shutdown) {
                    long current = System.currentTimeMillis();
                    for (HiveSession session : new ArrayList(SessionManager.this.handleToSession.values())) {
                        if (SessionManager.this.sessionTimeout > 0L && session.getLastAccessTime() + SessionManager.this.sessionTimeout <= current) {
                            SessionHandle handle = session.getSessionHandle();
                            LOG.warn((Object)("Session " + handle + " is Timed-out (last access : " + new Date(session.getLastAccessTime()) + ") and will be closed"));
                            try {
                                SessionManager.this.closeSession(handle);
                            }
                            catch (HiveSQLException e) {
                                LOG.warn((Object)("Exception is thrown closing session " + handle), (Throwable)e);
                            }
                            continue;
                        }
                        session.closeExpiredOperations();
                    }
                    this.sleepInterval(interval);
                }
            }

            private void sleepInterval(long interval2) {
                try {
                    Thread.sleep(interval2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.timeoutChecker.setName("Session Checker [" + interval + " msec]");
        this.timeoutChecker.setDaemon(true);
        this.timeoutChecker.start();
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.shutdown = true;
        if (this.timeoutChecker != null) {
            this.timeoutChecker.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionHandle openSession(String username, String password, Map<String, String> sessionConf, boolean withImpersonation, String delegationToken) throws HiveSQLException {
        HiveSession session;
        Object hiveSessionUgi;
        if (withImpersonation) {
            hiveSessionUgi = new HiveSessionImplwithUGI(username, password, sessionConf, threadLocalIpAddress.get(), delegationToken);
            session = HiveSessionProxy.getProxy((HiveSession)hiveSessionUgi, ((HiveSessionImplwithUGI)hiveSessionUgi).getSessionUgi());
            ((HiveSessionImplwithUGI)hiveSessionUgi).setProxySession(session);
        } else {
            session = new HiveSessionImpl(username, password, sessionConf, threadLocalIpAddress.get());
        }
        session.setSessionManager(this);
        session.setOperationManager(this.operationManager);
        session.setLogManager(this.logManager);
        hiveSessionUgi = sessionMapLock;
        synchronized (hiveSessionUgi) {
            this.handleToSession.put(session.getSessionHandle(), session);
        }
        try {
            this.executeSessionHooks(session);
        }
        catch (Exception e) {
            throw new HiveSQLException("Failed to execute session hooks", e);
        }
        return session.getSessionHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(SessionHandle sessionHandle) throws HiveSQLException {
        HiveSession session;
        Object object = sessionMapLock;
        synchronized (object) {
            session = this.handleToSession.remove(sessionHandle);
        }
        if (session == null) {
            throw new HiveSQLException("Session does not exist!");
        }
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiveSession getSession(SessionHandle sessionHandle) throws HiveSQLException {
        HiveSession session;
        Object object = sessionMapLock;
        synchronized (object) {
            session = this.handleToSession.get(sessionHandle);
        }
        if (session == null) {
            throw new HiveSQLException("Invalid SessionHandle: " + sessionHandle);
        }
        return session;
    }

    public OperationManager getOperationManager() {
        return this.operationManager;
    }

    public LogManager getLogManager() {
        return this.logManager;
    }

    public static void setIpAddress(String ipAddress) {
        threadLocalIpAddress.set(ipAddress);
    }

    private void clearIpAddress() {
        threadLocalIpAddress.remove();
    }

    public static String getIpAddress() {
        return threadLocalIpAddress.get();
    }

    public static void setUserName(String userName) {
        threadLocalUserName.set(userName);
    }

    private void clearUserName() {
        threadLocalUserName.remove();
    }

    public void clearThreadLocals() {
        this.clearIpAddress();
        this.clearUserName();
    }

    public static String getUserName() {
        return threadLocalUserName.get();
    }

    private void executeSessionHooks(HiveSession session) throws Exception {
        String[] hookClasses;
        String hookList = this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SESSION_HOOK).trim();
        if (hookList == null || hookList.isEmpty()) {
            return;
        }
        for (String hookClass : hookClasses = hookList.split(",")) {
            HiveSessionHook sessionHook = (HiveSessionHook)Class.forName(hookClass.trim(), true, JavaUtils.getClassLoader()).newInstance();
            sessionHook.run(new HiveSessionHookContextImpl(session));
        }
    }
}

