/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.common.ui.services;

import java.net.URLDecoder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.common.ui.messages.Messages;
import org.pentaho.common.ui.services.StateMessage;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;

public class SolutionRepoService
extends PentahoBase {
    private static final long serialVersionUID = 8445693289282403228L;

    public StateMessage saveStateString(String filepath, String state, String type, Boolean replace, String title, String description) throws Exception {
        return this.saveState(filepath, state, false, type, replace, title, description);
    }

    public StateMessage saveStateXml(String filepath, String state, String type, Boolean replace, String title, String description) throws Exception {
        return this.saveState(filepath, state, true, type, replace, title, description);
    }

    protected StateMessage saveState(String filepath, String state, boolean stateIsXml, String type, Boolean replace, String title, String description) throws Exception {
        ActionInfo info;
        StateMessage result = new StateMessage();
        result.setStatus("FAILED");
        if (StringUtils.isEmpty((String)filepath)) {
            result.setMessage(Messages.getErrorString("SolutionRepo.ERROR_0001_NO_FILEPATH"));
            return result;
        }
        if (StringUtils.isEmpty((String)state)) {
            result.setMessage(Messages.getErrorString("SolutionRepo.ERROR_0002_NO_STATE"));
            return result;
        }
        if (StringUtils.isEmpty((String)type)) {
            result.setMessage(Messages.getErrorString("SolutionRepo.ERROR_0007_NO_TYPE"));
            return result;
        }
        if (replace == null) {
            replace = Boolean.FALSE;
        }
        if ((info = ActionInfo.parseActionString((String)filepath)) == null) {
            result.setMessage(Messages.getErrorString("SolutionUrlContentGenerator.ERROR_0005_BAD_FILEPATH", filepath));
            return result;
        }
        IPentahoSession userSession = PentahoSessionHolder.getSession();
        return null;
    }

    public StateMessage loadState(String filepath) throws Exception {
        StateMessage result = new StateMessage();
        filepath = URLDecoder.decode(filepath);
        result.setStatus("FAILED");
        if (StringUtils.isEmpty((String)filepath)) {
            result.setMessage(Messages.getErrorString("SolutionRepo.ERROR_0001_NO_FILEPATH"));
            return result;
        }
        ActionInfo info = ActionInfo.parseActionString((String)filepath);
        if (info == null) {
            result.setMessage(Messages.getErrorString("SolutionRepo.ERROR_0003_BAD_PATH", filepath));
            return result;
        }
        IPentahoSession userSession = PentahoSessionHolder.getSession();
        return null;
    }

    public Log getLogger() {
        return LogFactory.getLog(SolutionRepoService.class);
    }
}

