/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.common.ui.services;

import flexjson.JSONSerializer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.common.ui.messages.Messages;
import org.pentaho.common.ui.services.JsonUtil;
import org.pentaho.common.ui.services.Setting;
import org.pentaho.common.ui.services.StatusMessage;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.usersettings.IUserSettingService;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class UserSettingService
extends PentahoBase {
    private static final long serialVersionUID = 1372909204550846766L;
    public static final String THEME_KEY = "common-ui-user-theme";

    public StatusMessage setUserSetting(String settingName, String settingValue) {
        JsonUtil utils = new JsonUtil();
        try {
            IUserSettingService settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)PentahoSessionHolder.getSession());
            settingsService.setUserSetting(settingName, settingValue);
            return utils.createMessage("SUCCESS", "0");
        }
        catch (Exception e) {
            return utils.createMessage(Messages.getString("UserSettingService.ERROR_0003_SETTINGS_WRITE", settingName), "InteractiveAdhocService.ERROR_0003_SETTINGS_WRITE");
        }
    }

    public String setUserSettingJson(String settingName, String settingValue) {
        StatusMessage msg = this.setUserSetting(settingName, settingValue);
        return new JSONSerializer().deepSerialize((Object)msg);
    }

    public Setting[] getUserSettings(String settingNames) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(settingNames, ",");
        IUserSettingService settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)PentahoSessionHolder.getSession());
        ArrayList<Setting> settings = new ArrayList<Setting>();
        while (tokenizer.hasMoreTokens()) {
            String settingName = tokenizer.nextToken();
            IUserSetting srcSetting = settingsService.getUserSetting(settingName, null);
            if (srcSetting == null) continue;
            String value = srcSetting.getSettingValue();
            Setting setting = new Setting();
            setting.setName(settingName);
            setting.setValue(value);
            settings.add(setting);
        }
        Setting[] settingArray = new Setting[settings.size()];
        settings.toArray(settingArray);
        return settingArray;
    }

    public String getUserSettingsJson(String settingNames) {
        JsonUtil utils = new JsonUtil();
        try {
            Setting[] settingArray = this.getUserSettings(settingNames);
            JSONSerializer serializer = new JSONSerializer();
            String json = serializer.deepSerialize((Object)settingArray);
            return json;
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("UserSettingService.ERROR_0002_SETTINGS_READ", e.getLocalizedMessage()), e);
            return utils.createJsonMessage(Messages.getString("UserSettingService.ERROR_0002_SETTINGS_READ", e.getLocalizedMessage()), "ERROR_0002_SETTINGS_READ");
        }
    }

    public Log getLogger() {
        return LogFactory.getLog(UserSettingService.class);
    }
}

