/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.datasources;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import pt.webdetails.cgg.datasources.DataSource;
import pt.webdetails.cgg.datasources.JsonExporter;

public abstract class AbstractDataSource
implements DataSource {
    protected String outputType = "json";
    private ArrayList<String> sortBy = new ArrayList();
    private HashMap<String, Object> parameter = new HashMap();
    private String query;
    private String path;

    protected String export(TableModel model) throws IOException {
        if (this.outputType.equals("json")) {
            JsonExporter exporter = new JsonExporter();
            return exporter.export(model);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String execute() throws IOException {
        TableModel model = this.performQuery();
        if (model == null) {
            return null;
        }
        if (!this.sortBy.isEmpty()) {
            model = this.sort(model);
        }
        return this.export(model);
    }

    protected HashMap<String, Object> getParameter() {
        return this.parameter;
    }

    private TableModel sort(TableModel model) {
        return model;
    }

    protected String getOutputType() {
        return this.outputType;
    }

    protected List<String> getSortBy() {
        return this.sortBy;
    }

    protected abstract TableModel performQuery();

    @Override
    public void setParameter(String param, Object val) {
        if ("outputType".equals(param)) {
            this.outputType = (String)val;
        }
        if ("sortBy".equals(param)) {
            String source;
            this.sortBy.clear();
            if (val instanceof Collection) {
                Collection valC = (Collection)val;
                for (Object o : valC) {
                    String s;
                    if (o == null || StringUtils.isEmpty((CharSequence)(s = String.valueOf(o)))) continue;
                    this.sortBy.add(s);
                }
            } else if (val != null && !StringUtils.isEmpty((CharSequence)(source = String.valueOf(val)))) {
                this.sortBy.add(source);
            }
        }
        this.parameter.put(param, val);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getDataAccessId() {
        return this.query;
    }

    public void setDataAccessId(String dataAccessId) {
        this.query = dataAccessId;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

