/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.scripts;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import pt.webdetails.cgg.ScriptExecuteException;
import pt.webdetails.cgg.scripts.BaseScope;
import pt.webdetails.cgg.scripts.BaseScript;
import pt.webdetails.cgg.scripts.Java2DScript;
import pt.webdetails.cgg.scripts.Script;
import pt.webdetails.cgg.scripts.ScriptFactory;
import pt.webdetails.cgg.scripts.ScriptResourceLoader;
import pt.webdetails.cgg.scripts.ScriptResourceNotFoundException;
import pt.webdetails.cgg.scripts.ScriptType;
import pt.webdetails.cgg.scripts.SvgScript;

public abstract class AbstractScriptFactory
implements ScriptFactory {
    private static final Log logger = LogFactory.getLog(AbstractScriptFactory.class);
    private ContextFactory contextFactory = new ContextFactory();
    private HashMap<ScriptType, BaseScope> contexts = new HashMap();

    protected AbstractScriptFactory() {
    }

    protected abstract ScriptResourceLoader getResourceLoader();

    @Override
    public Reader getSystemLibraryScript(String script) throws IOException, ScriptResourceNotFoundException {
        return this.getResourceLoader().getSystemLibraryScript(script);
    }

    @Override
    public Reader getContextLibraryScript(String script) throws IOException, ScriptResourceNotFoundException {
        return this.getResourceLoader().getContextLibraryScript(script);
    }

    @Override
    public String getContextResourceURI(String script) throws IOException, ScriptResourceNotFoundException {
        return this.getResourceLoader().getContextResourceURI(script);
    }

    @Override
    public InputStream getContextResource(String script) throws IOException, ScriptResourceNotFoundException {
        return this.getResourceLoader().getContextResource(script);
    }

    @Override
    public Script createScript(String path, String scriptType) throws ScriptResourceNotFoundException, ScriptExecuteException {
        ScriptType st = ScriptType.valueOf(scriptType.toUpperCase(Locale.ENGLISH));
        return this.createScript(path, st);
    }

    public Script createScript(String path, ScriptType scriptType) throws ScriptResourceNotFoundException, ScriptExecuteException {
        BaseScript script;
        switch (scriptType) {
            case SVG: {
                script = new SvgScript(path);
                break;
            }
            case J2D: {
                script = new Java2DScript(path);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        script.setScope(this.getScope(scriptType));
        return script;
    }

    @Override
    public void enterContext() {
        Context cx = this.contextFactory.enterContext();
        cx.setGeneratingDebug(false);
        cx.setOptimizationLevel(-1);
    }

    @Override
    public void exitContext() {
        Context.exit();
    }

    protected BaseScope getScope(ScriptType type) throws ScriptExecuteException {
        BaseScope o = this.contexts.get((Object)type);
        if (o != null) {
            return o;
        }
        o = this.createScope(type);
        this.contexts.put(type, o);
        return o;
    }

    protected BaseScope createScope(ScriptType type) throws ScriptExecuteException {
        String[] dependencies = this.computeDependencies(type);
        Context cx = this.contextFactory.enterContext();
        cx.setGeneratingDebug(false);
        cx.setOptimizationLevel(-1);
        BaseScope scope = new BaseScope();
        scope.setScriptFactory(this);
        scope.init(cx);
        for (String file : dependencies) {
            try {
                scope.loadSystemScript(cx, file);
            }
            catch (ScriptResourceNotFoundException ex) {
                logger.error((Object)("Failed to read " + file + ": " + ex.toString()));
            }
            catch (IOException e) {
                throw new ScriptExecuteException(e);
            }
        }
        Context.exit();
        return scope;
    }

    protected String[] computeDependencies(ScriptType type) {
        return new String[0];
    }

    @Override
    public void clearCachedScopes() {
    }
}

