/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cgg.scripts;

import java.awt.image.BufferedImage;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import pt.webdetails.cgg.Chart;
import pt.webdetails.cgg.Java2DChart;
import pt.webdetails.cgg.ScriptExecuteException;
import pt.webdetails.cgg.datasources.DataSourceFactory;
import pt.webdetails.cgg.scripts.BaseScope;
import pt.webdetails.cgg.scripts.BaseScript;
import pt.webdetails.cgg.scripts.ScriptFactory;

public class Java2DScript
extends BaseScript {
    private BufferedImage imageBuffer;
    private long width;
    private long height;

    public Java2DScript(String source) {
        super(source);
    }

    @Override
    public void configure(int width, int height, DataSourceFactory dataSourceFactory, ScriptFactory scriptFactory) throws ScriptExecuteException {
        super.configure(width, height, dataSourceFactory, scriptFactory);
        this.width = width;
        this.height = height;
    }

    @Override
    public Chart execute(Map<String, Object> params) throws ScriptExecuteException {
        if (Context.getCurrentContext() == null) {
            throw new ScriptExecuteException();
        }
        Context.getCurrentContext().getFactory().enterContext();
        try {
            this.addGraphicsToScope();
            this.executeScript(params);
            Java2DChart java2DChart = new Java2DChart(this.imageBuffer);
            return java2DChart;
        }
        catch (Exception e) {
            throw new ScriptExecuteException(e);
        }
        finally {
            Context.exit();
        }
    }

    private void addGraphicsToScope() {
        BaseScope scope = this.getScope();
        this.imageBuffer = new BufferedImage((int)this.width, (int)this.height, 6);
        Object wrappedGraphics = Context.javaToJS((Object)this.imageBuffer.createGraphics(), (Scriptable)scope);
        ScriptableObject.putProperty((Scriptable)scope, (String)"graphics", (Object)wrappedGraphics);
    }
}

