/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.WritableRpcEngine;
import org.apache.hadoop.mapred.HAUtil;
import org.apache.hadoop.mapred.InterTrackerProtocol;
import org.apache.hadoop.mapred.JTProtocols;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobSubmissionProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;

public class JobTrackerProxies {
    private static final Log LOG = LogFactory.getLog(JobTrackerProxies.class);

    public static <T> ProxyAndInfo<T> createProxy(Configuration conf, String jtAddress, Class<T> xface) throws IOException {
        Class<FailoverProxyProvider<T>> failoverProxyProviderClass = JobTrackerProxies.getFailoverProxyProviderClass(conf, jtAddress, xface);
        if (failoverProxyProviderClass == null) {
            return JobTrackerProxies.createNonHAProxy(conf, NetUtils.createSocketAddr((String)jtAddress), xface, UserGroupInformation.getCurrentUser(), true);
        }
        FailoverProxyProvider<T> failoverProxyProvider = JobTrackerProxies.createFailoverProxyProvider(conf, failoverProxyProviderClass, xface, jtAddress);
        int maxFailoverAttempts = conf.getInt("mapred.client.failover.max.attempts", 15);
        long failoverSleepBaseMillis = conf.getInt("mapred.client.failover.sleep.base.millis", 500);
        long failoverSleepMaxMillis = conf.getInt("mapred.client.failover.sleep.max.millis", 15000);
        Object proxy = RetryProxy.create(xface, failoverProxyProvider, (RetryPolicy)RetryPolicies.failoverOnNetworkException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)maxFailoverAttempts, (long)failoverSleepBaseMillis, (long)failoverSleepMaxMillis));
        Text dtService = HAUtil.buildTokenServiceForLogicalAddress(jtAddress);
        return new ProxyAndInfo<Object>(proxy, dtService);
    }

    private static <T> Class<FailoverProxyProvider<T>> getFailoverProxyProviderClass(Configuration conf, String jtAddress, Class<T> xface) throws IOException {
        if (jtAddress == null) {
            return null;
        }
        String configKey = DFSUtil.addKeySuffixes((String)"mapred.client.failover.proxy.provider", (String[])new String[]{HAUtil.getLogicalName(jtAddress)});
        return conf.getClass(configKey, null, FailoverProxyProvider.class);
    }

    public static <T> ProxyAndInfo<T> createNonHAProxy(Configuration conf, InetSocketAddress jtAddr, Class<T> xface, UserGroupInformation ugi, boolean withRetries) throws IOException {
        Object proxy;
        Text dtService = SecurityUtil.buildTokenService((InetSocketAddress)jtAddr);
        if (xface == JobSubmissionProtocol.class) {
            proxy = JobTrackerProxies.createJTProxyWithJobSubmissionProtocol(jtAddr, conf, ugi, withRetries);
        } else if (xface == InterTrackerProtocol.class) {
            proxy = JobTrackerProxies.createJTProxyWithInterTrackerProtocol(jtAddr, conf, ugi, withRetries);
        } else {
            throw new IOException("wrong protocol");
        }
        return new ProxyAndInfo<JobSubmissionProtocol>((JobSubmissionProtocol)proxy, dtService);
    }

    private static JobSubmissionProtocol createJTProxyWithJobSubmissionProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, boolean withRetries) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, JobSubmissionProtocol.class, WritableRpcEngine.class);
        long version = RPC.getProtocolVersion(JobSubmissionProtocol.class);
        int rpcTimeout = JobClient.getRpcTimeout(conf);
        RPC.getProxy(JobSubmissionProtocol.class, (long)version, (InetSocketAddress)address, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)rpcTimeout);
        JobSubmissionProtocol proxy = (JobSubmissionProtocol)RPC.getProtocolProxy(JobSubmissionProtocol.class, (long)version, (InetSocketAddress)address, (UserGroupInformation)ugi, (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)rpcTimeout, null).getProxy();
        return proxy;
    }

    private static InterTrackerProtocol createJTProxyWithInterTrackerProtocol(InetSocketAddress address, Configuration conf, UserGroupInformation ugi, boolean withRetries) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, InterTrackerProtocol.class, WritableRpcEngine.class);
        return (InterTrackerProtocol)RPC.waitForProtocolProxy(InterTrackerProtocol.class, (long)32L, (InetSocketAddress)address, (Configuration)conf).getProxy();
    }

    private static <T> FailoverProxyProvider<T> createFailoverProxyProvider(Configuration conf, Class<FailoverProxyProvider<T>> failoverProxyProviderClass, Class<T> xface, String jtAddress) throws IOException {
        Preconditions.checkArgument((boolean)xface.isAssignableFrom(JTProtocols.class), (String)"Interface %s is not a JobTracker protocol", (Object[])new Object[]{xface});
        try {
            Constructor<FailoverProxyProvider<T>> ctor = failoverProxyProviderClass.getConstructor(Configuration.class, String.class, Class.class);
            FailoverProxyProvider<T> provider = ctor.newInstance(conf, jtAddress, xface);
            return provider;
        }
        catch (Exception e) {
            String message = "Couldn't create proxy provider " + failoverProxyProviderClass;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message, (Throwable)e);
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(message, e);
        }
    }

    public static class ProxyAndInfo<PROXYTYPE> {
        private final PROXYTYPE proxy;
        private final Text dtService;

        public ProxyAndInfo(PROXYTYPE proxy, Text dtService) {
            this.proxy = proxy;
            this.dtService = dtService;
        }

        public PROXYTYPE getProxy() {
            return this.proxy;
        }

        public Text getDelegationTokenService() {
            return this.dtService;
        }
    }
}

