/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.Operation;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;

public class TaskLogServlet
extends HttpServlet {
    private static final long serialVersionUID = -6615764817774487321L;
    private static final Log LOG = LogFactory.getLog(TaskLog.class);

    private boolean haveTaskLog(TaskAttemptID taskId, boolean isCleanup, TaskLog.LogName type) {
        File f = TaskLog.getTaskLogFile(taskId, isCleanup, type);
        return f.canRead();
    }

    public static String getTaskLogUrl(String taskTrackerHostName, String httpPort, String taskAttemptID) {
        return HttpConfig.getSchemePrefix() + taskTrackerHostName + ":" + httpPort + "/tasklog?attemptid=" + taskAttemptID;
    }

    public static String getTaskLogUrl(TaskTrackerStatus status, String taskAttemptID) {
        return TaskLogServlet.getTaskLogUrl(status.getHost(), String.valueOf(status.getHttpPort()), taskAttemptID);
    }

    private void printTaskLog(HttpServletResponse response, OutputStream out, TaskAttemptID taskId, long start, long end, boolean plainText, TaskLog.LogName filter, boolean isCleanup) throws IOException {
        if (!plainText) {
            out.write(("<br><b><u>" + (Object)((Object)filter) + " logs</u></b><br>\n" + "<pre>\n").getBytes());
        }
        try {
            int result;
            TaskLog.Reader taskLogReader = new TaskLog.Reader(taskId, filter, start, end, isCleanup);
            byte[] b = new byte[65536];
            while ((result = taskLogReader.read(b)) > 0) {
                if (plainText) {
                    out.write(b, 0, result);
                    continue;
                }
                HtmlQuoting.quoteHtmlChars((OutputStream)out, (byte[])b, (int)0, (int)result);
            }
            ((InputStream)taskLogReader).close();
            if (!plainText) {
                out.write("</pre><hr><br>\n".getBytes());
            }
        }
        catch (IOException ioe) {
            if (filter == TaskLog.LogName.DEBUGOUT) {
                if (!plainText) {
                    out.write("</pre><hr><br>\n".getBytes());
                }
            }
            String msg = "Failed to retrieve " + (Object)((Object)filter) + " log for task: " + taskId;
            LOG.warn((Object)msg, (Throwable)ioe);
            response.sendError(410, msg);
        }
    }

    private void checkAccessForTaskLogs(JobConf conf, String user, String jobId, TaskTracker tracker) throws AccessControlException {
        if (!tracker.areACLsEnabled()) {
            return;
        }
        AccessControlList jobViewACL = tracker.getJobACLsManager().constructJobACLs(conf).get((Object)JobACL.VIEW_JOB);
        String queue = conf.getQueueName();
        AccessControlList queueAdminsACL = new AccessControlList(conf.get(QueueManager.toFullPropertyName(queue, QueueManager.QueueACL.ADMINISTER_JOBS.getAclName()), " "));
        String jobOwner = conf.get("user.name");
        UserGroupInformation callerUGI = UserGroupInformation.createRemoteUser((String)user);
        if (!queueAdminsACL.isUserAllowed(callerUGI)) {
            tracker.getACLsManager().checkAccess(jobId, callerUGI, queue, Operation.VIEW_TASK_LOGS, jobOwner, jobViewACL);
        }
    }

    static JobConf getConfFromJobACLsFile(JobID jobId) {
        Path jobAclsFilePath = new Path(TaskLog.getJobDir(jobId).toString(), TaskTracker.jobACLsFile);
        JobConf conf = null;
        if (new File(jobAclsFilePath.toUri().getPath()).exists()) {
            conf = new JobConf(false);
            conf.addResource(jobAclsFilePath);
        }
        return conf;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        TaskAttemptID attemptId;
        String sCleanup;
        String sPlainText;
        String sLogEnd;
        String sLogOff;
        long start = 0L;
        long end = -1L;
        boolean plainText = false;
        TaskLog.LogName filter = null;
        boolean isCleanup = false;
        String attemptIdStr = request.getParameter("attemptid");
        if (attemptIdStr == null) {
            response.sendError(400, "Argument attemptid is required");
            return;
        }
        String logFilter = request.getParameter("filter");
        if (logFilter != null) {
            try {
                filter = TaskLog.LogName.valueOf(TaskLog.LogName.class, logFilter.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                response.sendError(400, "Illegal value for filter: " + logFilter);
                return;
            }
        }
        if ((sLogOff = request.getParameter("start")) != null) {
            start = Long.valueOf(sLogOff);
        }
        if ((sLogEnd = request.getParameter("end")) != null) {
            end = Long.valueOf(sLogEnd);
        }
        if ((sPlainText = request.getParameter("plaintext")) != null) {
            plainText = Boolean.valueOf(sPlainText);
        }
        if ((sCleanup = request.getParameter("cleanup")) != null) {
            isCleanup = Boolean.valueOf(sCleanup);
        }
        if (!TaskLog.getAttemptDir(attemptId = TaskAttemptID.forName(attemptIdStr), isCleanup).exists()) {
            response.sendError(410, "Task log directory for task " + attemptId + " does not exist. May be cleaned up by Task Tracker, if older logs.");
            return;
        }
        String user = request.getRemoteUser();
        if (user != null) {
            ServletContext context = this.getServletContext();
            TaskTracker taskTracker = (TaskTracker)context.getAttribute("task.tracker");
            JobID jobId = attemptId.getJobID();
            JobConf jobACLConf = TaskLogServlet.getConfFromJobACLsFile(jobId);
            if (jobACLConf != null) {
                try {
                    this.checkAccessForTaskLogs(jobACLConf, user, jobId.toString(), taskTracker);
                }
                catch (AccessControlException e) {
                    String errMsg = "User " + user + " failed to view tasklogs of job " + jobId + "!\n\n" + e.getMessage();
                    response.sendError(401, errMsg);
                    return;
                }
            }
        }
        ServletOutputStream out = response.getOutputStream();
        response.setContentType("text/html; charset=utf-8");
        if (!plainText) {
            out.write(("<html>\n<title>Task Logs: '" + attemptId + "'</title>\n" + "<body>\n" + "<h1>Task Logs: '" + attemptId + "'</h1><br>\n").getBytes());
            if (filter == null) {
                this.printTaskLog(response, (OutputStream)out, attemptId, start, end, plainText, TaskLog.LogName.STDOUT, isCleanup);
                this.printTaskLog(response, (OutputStream)out, attemptId, start, end, plainText, TaskLog.LogName.STDERR, isCleanup);
                if (this.haveTaskLog(attemptId, isCleanup, TaskLog.LogName.SYSLOG)) {
                    this.printTaskLog(response, (OutputStream)out, attemptId, start, end, plainText, TaskLog.LogName.SYSLOG, isCleanup);
                }
                if (this.haveTaskLog(attemptId, isCleanup, TaskLog.LogName.DEBUGOUT)) {
                    this.printTaskLog(response, (OutputStream)out, attemptId, start, end, plainText, TaskLog.LogName.DEBUGOUT, isCleanup);
                }
                if (this.haveTaskLog(attemptId, isCleanup, TaskLog.LogName.PROFILE)) {
                    this.printTaskLog(response, (OutputStream)out, attemptId, start, end, plainText, TaskLog.LogName.PROFILE, isCleanup);
                }
            } else {
                this.printTaskLog(response, (OutputStream)out, attemptId, start, end, plainText, filter, isCleanup);
            }
            out.write("</body></html>\n".getBytes());
            out.close();
        } else if (filter == null) {
            response.sendError(400, "You must supply a value for `filter' (STDOUT, STDERR, or SYSLOG) if you set plainText = true");
        } else {
            response.setContentType("text/plain; charset=utf-8");
            this.printTaskLog(response, (OutputStream)out, attemptId, start, end, plainText, filter, isCleanup);
        }
    }
}

