/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.DelegatingInputFormat;
import org.apache.hadoop.mapreduce.lib.input.DelegatingMapper;
import org.apache.hadoop.util.ReflectionUtils;

public class MultipleInputs {
    public static void addInputPath(Job job, Path path, Class<? extends InputFormat> inputFormatClass) {
        Configuration conf;
        String inputFormatMapping = path.toString() + ";" + inputFormatClass.getName();
        String inputFormats = (conf = job.getConfiguration()).get("mapred.input.dir.formats");
        conf.set("mapred.input.dir.formats", inputFormats == null ? inputFormatMapping : inputFormats + "," + inputFormatMapping);
        job.setInputFormatClass(DelegatingInputFormat.class);
    }

    public static void addInputPath(Job job, Path path, Class<? extends InputFormat> inputFormatClass, Class<? extends Mapper> mapperClass) {
        MultipleInputs.addInputPath(job, path, inputFormatClass);
        Configuration conf = job.getConfiguration();
        String mapperMapping = path.toString() + ";" + mapperClass.getName();
        String mappers = conf.get("mapred.input.dir.mappers");
        conf.set("mapred.input.dir.mappers", mappers == null ? mapperMapping : mappers + "," + mapperMapping);
        job.setMapperClass(DelegatingMapper.class);
    }

    static Map<Path, InputFormat> getInputFormatMap(JobContext job) {
        String[] pathMappings;
        HashMap<Path, InputFormat> m = new HashMap<Path, InputFormat>();
        Configuration conf = job.getConfiguration();
        for (String pathMapping : pathMappings = conf.get("mapred.input.dir.formats").split(",")) {
            InputFormat inputFormat;
            String[] split = pathMapping.split(";");
            try {
                inputFormat = (InputFormat)ReflectionUtils.newInstance((Class)conf.getClassByName(split[1]), (Configuration)conf);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            m.put(new Path(split[0]), inputFormat);
        }
        return m;
    }

    static Map<Path, Class<? extends Mapper>> getMapperTypeMap(JobContext job) {
        String[] pathMappings;
        Configuration conf = job.getConfiguration();
        if (conf.get("mapred.input.dir.mappers") == null) {
            return Collections.emptyMap();
        }
        HashMap<Path, Class<? extends Mapper>> m = new HashMap<Path, Class<? extends Mapper>>();
        for (String pathMapping : pathMappings = conf.get("mapred.input.dir.mappers").split(",")) {
            Class mapClass;
            String[] split = pathMapping.split(";");
            try {
                mapClass = conf.getClassByName(split[1]);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            m.put(new Path(split[0]), mapClass);
        }
        return m;
    }
}

