/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.SortColInfo;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.impl.util.Utils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SortInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    boolean isGloballySorted = true;
    List<SortColInfo> sortColInfoList;

    public SortInfo(List<SortColInfo> sortColInfoList) {
        this.sortColInfoList = sortColInfoList;
    }

    public List<SortColInfo> getSortColInfoList() {
        return new ArrayList<SortColInfo>(this.sortColInfoList);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sortColInfoList == null ? 0 : ((Object)this.sortColInfoList).hashCode());
        result = 31 * result + (this.isGloballySorted ? 1 : 0);
        return result;
    }

    public boolean isGloballySorted() {
        return this.isGloballySorted;
    }

    public boolean equals(Object obj) {
        if (!Utils.checkNullAndClass(this, obj)) {
            return false;
        }
        SortInfo other = (SortInfo)obj;
        return this.isGloballySorted == other.isGloballySorted && Utils.checkNullEquals(this.sortColInfoList, other.sortColInfoList, true);
    }

    public String toString() {
        return "GlobalSort:" + this.isGloballySorted + ", sort column info list:" + this.sortColInfoList;
    }
}

