/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigReducerEstimator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;
import org.apache.pig.impl.util.UriUtil;

public class InputSizeReducerEstimator
implements PigReducerEstimator {
    private static final Log log = LogFactory.getLog(InputSizeReducerEstimator.class);

    @Override
    public int estimateNumberOfReducers(Job job, MapReduceOper mapReduceOper) throws IOException {
        Configuration conf = job.getConfiguration();
        long bytesPerReducer = conf.getLong("pig.exec.reducers.bytes.per.reducer", 1000000000L);
        int maxReducers = conf.getInt("pig.exec.reducers.max", 999);
        LinkedList<POLoad> poLoads = PlanHelper.getPhysicalOperators(mapReduceOper.mapPlan, POLoad.class);
        long totalInputFileSize = InputSizeReducerEstimator.getTotalInputFileSize(conf, poLoads, job);
        log.info((Object)("BytesPerReducer=" + bytesPerReducer + " maxReducers=" + maxReducers + " totalInputFileSize=" + totalInputFileSize));
        if (totalInputFileSize == -1L) {
            return -1;
        }
        int reducers = (int)Math.ceil((double)totalInputFileSize / (double)bytesPerReducer);
        reducers = Math.max(1, reducers);
        reducers = Math.min(maxReducers, reducers);
        return reducers;
    }

    static long getTotalInputFileSize(Configuration conf, List<POLoad> lds, Job job) throws IOException {
        long totalInputFileSize = 0L;
        boolean foundSize = false;
        for (POLoad ld : lds) {
            long size = InputSizeReducerEstimator.getInputSizeFromLoader(ld, job);
            if (size > -1L) {
                foundSize = true;
            }
            if (size > 0L) {
                totalInputFileSize += size;
                continue;
            }
            for (String location : LoadFunc.getPathStrings(ld.getLFile().getFileName())) {
                Path path;
                FileSystem fs;
                FileStatus[] status;
                if (!UriUtil.isHDFSFileOrLocalOrS3N(location) || (status = (fs = (path = new Path(location)).getFileSystem(conf)).globStatus(path)) == null) continue;
                for (FileStatus s : status) {
                    totalInputFileSize += MapRedUtil.getPathLength(fs, s);
                    foundSize = true;
                }
            }
        }
        return foundSize ? totalInputFileSize : -1L;
    }

    static long getInputSizeFromLoader(POLoad ld, Job job) throws IOException {
        ResourceStatistics statistics;
        if (ld.getLoadFunc() == null || !(ld.getLoadFunc() instanceof LoadMetadata) || ld.getLFile() == null || ld.getLFile().getFileName() == null) {
            return -1L;
        }
        try {
            statistics = ((LoadMetadata)((Object)ld.getLoadFunc())).getStatistics(ld.getLFile().getFileName(), job);
        }
        catch (Exception e) {
            log.warn((Object)("Couldn't get statistics from LoadFunc: " + ld.getLoadFunc()), (Throwable)e);
            return -1L;
        }
        if (statistics == null || statistics.getSizeInBytes() == null) {
            return -1L;
        }
        return statistics.getSizeInBytes();
    }
}

