/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop23;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.jobcontrol.JobControl;
import org.apache.hadoop.mapreduce.lib.jobcontrol.ControlledJob;
import org.apache.hadoop.mapreduce.lib.jobcontrol.JobControl;

public class PigJobControl
extends JobControl {
    private static final Log log = LogFactory.getLog(PigJobControl.class);
    private static Field runnerState;
    private static Field jobsInProgress;
    private static Field successfulJobs;
    private static Field failedJobs;
    private static Method failAllJobs;
    private static Method checkState;
    private static Method submit;
    private static boolean initSuccesful;
    private int timeToSleep;

    public PigJobControl(String groupName, int timeToSleep) {
        super(groupName);
        this.timeToSleep = timeToSleep;
    }

    public int getTimeToSleep() {
        return this.timeToSleep;
    }

    public void setTimeToSleep(int timeToSleep) {
        this.timeToSleep = timeToSleep;
    }

    private void setRunnerState(JobControl.ThreadState state) {
        try {
            runnerState.set((Object)this, state);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JobControl.ThreadState getRunnerState() {
        try {
            return (JobControl.ThreadState)runnerState.get((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ControlledJob.State checkState(ControlledJob j) {
        try {
            return (ControlledJob.State)checkState.invoke((Object)j, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ControlledJob.State submit(ControlledJob j) {
        try {
            return (ControlledJob.State)submit.invoke((Object)j, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private LinkedList<ControlledJob> getJobs(Field field) {
        try {
            return (LinkedList)field.get((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void failAllJobs(Throwable t) {
        try {
            failAllJobs.invoke((Object)this, t);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!initSuccesful) {
            super.run();
            return;
        }
        try {
            this.setRunnerState(JobControl.ThreadState.RUNNING);
            while (true) {
                if (this.getRunnerState() == JobControl.ThreadState.SUSPENDED) {
                    try {
                        Thread.sleep(this.timeToSleep);
                    }
                    catch (Exception e) {}
                    continue;
                }
                PigJobControl e = this;
                synchronized (e) {
                    Iterator it = this.getJobs(jobsInProgress).iterator();
                    while (it.hasNext()) {
                        ControlledJob j = (ControlledJob)it.next();
                        log.debug((Object)("Checking state of job " + j));
                        switch (this.checkState(j)) {
                            case SUCCESS: {
                                this.getJobs(successfulJobs).add(j);
                                it.remove();
                                break;
                            }
                            case FAILED: 
                            case DEPENDENT_FAILED: {
                                this.getJobs(failedJobs).add(j);
                                it.remove();
                                break;
                            }
                            case READY: {
                                this.submit(j);
                                break;
                            }
                        }
                    }
                }
                if (this.getRunnerState() != JobControl.ThreadState.RUNNING && this.getRunnerState() != JobControl.ThreadState.SUSPENDED) break;
                try {
                    Thread.sleep(this.timeToSleep);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (this.getRunnerState() != JobControl.ThreadState.RUNNING && this.getRunnerState() != JobControl.ThreadState.SUSPENDED) break;
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error while trying to run jobs.", t);
            this.failAllJobs(t);
        }
        this.setRunnerState(JobControl.ThreadState.STOPPED);
    }

    static {
        try {
            runnerState = org.apache.hadoop.mapreduce.lib.jobcontrol.JobControl.class.getDeclaredField("runnerState");
            runnerState.setAccessible(true);
            jobsInProgress = org.apache.hadoop.mapreduce.lib.jobcontrol.JobControl.class.getDeclaredField("jobsInProgress");
            jobsInProgress.setAccessible(true);
            successfulJobs = org.apache.hadoop.mapreduce.lib.jobcontrol.JobControl.class.getDeclaredField("successfulJobs");
            successfulJobs.setAccessible(true);
            failedJobs = org.apache.hadoop.mapreduce.lib.jobcontrol.JobControl.class.getDeclaredField("failedJobs");
            failedJobs.setAccessible(true);
            failAllJobs = org.apache.hadoop.mapreduce.lib.jobcontrol.JobControl.class.getDeclaredMethod("failAllJobs", Throwable.class);
            failAllJobs.setAccessible(true);
            checkState = ControlledJob.class.getDeclaredMethod("checkState", new Class[0]);
            checkState.setAccessible(true);
            submit = ControlledJob.class.getDeclaredMethod("submit", new Class[0]);
            submit.setAccessible(true);
            initSuccesful = true;
        }
        catch (Exception e) {
            log.warn((Object)"falling back to default JobControl (not using hadoop 0.23 ?)", (Throwable)e);
            initSuccesful = false;
        }
    }
}

