/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.shock;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.shock.SSHSocketFactory;
import org.apache.pig.shock.SSHSocketImpl;

public class SSHSocketImplFactory
implements SocketImplFactory,
Logger {
    private static final Log log = LogFactory.getLog(SSHSocketImplFactory.class);
    Session session;
    static HashMap<String, SSHSocketImplFactory> factories = new HashMap();

    public static SSHSocketImplFactory getFactory() throws JSchException, IOException {
        return SSHSocketImplFactory.getFactory(System.getProperty("ssh.gateway"));
    }

    public static synchronized SSHSocketImplFactory getFactory(String host) throws JSchException, IOException {
        SSHSocketImplFactory factory = factories.get(host);
        if (factory == null) {
            factory = new SSHSocketImplFactory(host);
            factories.put(host, factory);
        }
        return factory;
    }

    private SSHSocketImplFactory(String host) throws JSchException, IOException {
        JSch jsch = new JSch();
        JSch.setLogger((Logger)this);
        String passphrase = "";
        String defaultSSHDir = System.getProperty("user.home") + "/.ssh";
        String identityFile = defaultSSHDir + "/openid";
        String user = System.getProperty("user.name");
        user = System.getProperty("ssh.user", user);
        if (host == null) {
            throw new RuntimeException("ssh.gateway system property must be set");
        }
        String knownHosts = defaultSSHDir + "/known_hosts";
        knownHosts = System.getProperty("ssh.knownhosts", knownHosts);
        jsch.setKnownHosts(knownHosts);
        identityFile = System.getProperty("ssh.identity", identityFile);
        jsch.addIdentity(identityFile, passphrase.getBytes());
        this.session = jsch.getSession(user, host);
        Properties props = new Properties();
        props.put("compression.s2c", "none");
        props.put("compression.c2s", "none");
        props.put("cipher.s2c", "blowfish-cbc,3des-cbc");
        props.put("cipher.c2s", "blowfish-cbc,3des-cbc");
        if (jsch.getHostKeyRepository().getHostKey(host, null) == null) {
            props.put("StrictHostKeyChecking", "no");
        }
        this.session.setConfig(props);
        this.session.setDaemonThread(true);
        SSHSocketFactory sfactory = new SSHSocketFactory();
        this.session.setSocketFactory((SocketFactory)sfactory);
        UserInfo userinfo = null;
        this.session.setUserInfo(userinfo);
        this.session.connect();
        if (!this.session.isConnected()) {
            throw new IOException("Session not connected");
        }
    }

    @Override
    public SocketImpl createSocketImpl() {
        return new SSHSocketImpl(this.session);
    }

    public boolean isEnabled(int arg0) {
        return false;
    }

    public void log(int arg0, String arg1) {
        log.error((Object)(arg0 + ": " + arg1));
    }

    public Process ssh(String cmd) throws JSchException, IOException {
        ChannelExec channel = (ChannelExec)this.session.openChannel("exec");
        channel.setCommand(cmd);
        channel.setPty(true);
        channel.connect();
        return new SSHProcess(channel);
    }

    static class SSHProcess
    extends Process {
        ChannelExec channel;
        InputStream is;
        InputStream es;
        OutputStream os;

        SSHProcess(ChannelExec channel) throws IOException {
            this.channel = channel;
            this.is = channel.getInputStream();
            this.es = channel.getErrStream();
            this.os = channel.getOutputStream();
        }

        @Override
        public void destroy() {
            this.channel.disconnect();
        }

        @Override
        public int exitValue() {
            return this.channel.getExitStatus();
        }

        @Override
        public InputStream getErrorStream() {
            return this.es;
        }

        @Override
        public InputStream getInputStream() {
            return this.is;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.os;
        }

        @Override
        public int waitFor() throws InterruptedException {
            while (this.channel.isConnected()) {
                Thread.sleep(1000L);
            }
            return this.channel.getExitStatus();
        }
    }
}

