/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.productivity.java.syslog4j.Syslog;
import org.productivity.java.syslog4j.SyslogConfigIF;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.util.SyslogUtility;

public class SyslogMain {
    public static void usage(String string) {
        if (string != null) {
            System.out.println("Error: " + string);
            System.out.println();
        }
        System.out.println("Usage:");
        System.out.println();
        System.out.println("Syslog [-h <host>] [-p <port>] [-l <level>] [-f <facility>]");
        System.out.println("       <protocol>");
        System.out.println();
        System.out.println("Syslog [-h <host>] [-p <port>] [-l <level>] [-f <facility>]");
        System.out.println("       <protocol> [message...]");
        System.out.println();
        System.out.println("Syslog [-h <host>] [-p <port>] [-l <level>] [-f <facility>]");
        System.out.println("       -i <file> <protocol>");
        System.out.println();
        System.out.println("-h <host>      host or IP to send message (default: localhost)");
        System.out.println("-p <port>      port to send message (default: 514)");
        System.out.println("-l <level>     syslog level to use (default: INFO)");
        System.out.println("-f <facility>  syslog facility to use (default: USER)");
        System.out.println("-i <file>      input taken from the specified file");
        System.out.println();
        System.out.println("-q             do not write anything to standard out");
        System.out.println();
        System.out.println("protocol       Syslog4j protocol implementation");
        System.out.println("message        syslog message text");
        System.out.println();
        System.out.println("Notes:");
        System.out.println();
        System.out.println("Additional message arguments will be concatenated into the same");
        System.out.println("syslog message; calling SyslogMain will only send one message per call.");
        System.out.println();
        System.out.println("If the message argument is ommited, lines will be taken from the");
        System.out.println("standard input.");
    }

    public static Options parseOptions(String[] stringArray) {
        Options options = new Options();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n++];
            boolean bl = false;
            if ("-h".equals(string)) {
                if (n == stringArray.length) {
                    options.usage = "Must specify host with -h";
                    return options;
                }
                bl = true;
                options.host = stringArray[n++];
            }
            if ("-p".equals(string)) {
                if (n == stringArray.length) {
                    options.usage = "Must specify port with -p";
                    return options;
                }
                bl = true;
                options.port = stringArray[n++];
            }
            if ("-l".equals(string)) {
                if (n == stringArray.length) {
                    options.usage = "Must specify level with -l";
                    return options;
                }
                bl = true;
                options.level = stringArray[n++];
            }
            if ("-f".equals(string)) {
                if (n == stringArray.length) {
                    options.usage = "Must specify facility with -f";
                    return options;
                }
                bl = true;
                options.facility = stringArray[n++];
            }
            if ("-i".equals(string)) {
                if (n == stringArray.length) {
                    options.usage = "Must specify file with -i";
                    return options;
                }
                bl = true;
                options.fileName = stringArray[n++];
            }
            if ("-q".equals(string)) {
                bl = true;
                options.quiet = true;
            }
            if (options.protocol == null && !bl) {
                bl = true;
                options.protocol = string;
            }
            if (bl) continue;
            if (options.message == null) {
                options.message = string;
                continue;
            }
            options.message = options.message + " " + string;
        }
        if (options.protocol == null) {
            options.usage = "Must specify protocol";
            return options;
        }
        if (options.message != null && options.fileName != null) {
            options.usage = "Must specify either -i <file> or <message>, not both";
            return options;
        }
        return options;
    }

    public static void main(String[] stringArray) throws Exception {
        SyslogMain.main(stringArray, true);
    }

    public static void main(String[] stringArray, boolean bl) throws Exception {
        Options options = SyslogMain.parseOptions(stringArray);
        if (options.usage != null) {
            SyslogMain.usage(options.usage);
            System.exit(1);
        }
        if (!options.quiet) {
            System.out.println("Syslog " + Syslog.getVersion());
        }
        if (!Syslog.exists(options.protocol)) {
            SyslogMain.usage("Protocol \"" + options.protocol + "\" not supported");
            System.exit(1);
        }
        SyslogIF syslogIF = Syslog.getInstance(options.protocol);
        SyslogConfigIF syslogConfigIF = syslogIF.getConfig();
        if (options.host != null) {
            syslogConfigIF.setHost(options.host);
            if (!options.quiet) {
                System.out.println("Sending to host: " + options.host);
            }
        }
        if (options.port != null) {
            syslogConfigIF.setPort(Integer.parseInt(options.port));
            if (!options.quiet) {
                System.out.println("Sending to port: " + options.port);
            }
        }
        int n = SyslogUtility.getLevel(options.level);
        syslogConfigIF.setFacility(options.facility);
        if (options.message != null) {
            if (!options.quiet) {
                System.out.println("Sending " + options.facility + "." + options.level + " message \"" + options.message + "\"");
            }
            syslogIF.log(n, options.message);
        } else {
            InputStream inputStream = null;
            inputStream = options.fileName != null ? new FileInputStream(options.fileName) : System.in;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            while (string != null && string.length() > 0) {
                if (!options.quiet) {
                    System.out.println("Sending " + options.facility + "." + options.level + " message \"" + string + "\"");
                }
                syslogIF.log(n, string);
                string = bufferedReader.readLine();
            }
        }
        if (bl) {
            Syslog.shutdown();
        }
    }

    public static class Options {
        public String host = null;
        public String port = null;
        public String level = "INFO";
        public String facility = "USER";
        public String protocol = null;
        public String message = null;
        public String fileName = null;
        public boolean quiet = false;
        public String usage = null;
    }
}

