/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.bookmarks;

import com.tonbeller.wcf.bookmarks.Bookmarkable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class BookmarkManager {
    private HttpSession session;
    private Map state = Collections.EMPTY_MAP;
    private static final String WEBKEY = BookmarkManager.class.getName();

    BookmarkManager(HttpSession session) {
        this.session = session;
    }

    public static BookmarkManager instance(HttpSession session) {
        BookmarkManager bm = (BookmarkManager)session.getAttribute(WEBKEY);
        if (bm == null) {
            bm = new BookmarkManager(session);
            session.setAttribute(WEBKEY, (Object)bm);
        }
        return bm;
    }

    public Object collectSessionState(int levelOfDetail) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration en = this.session.getAttributeNames();
        while (en.hasMoreElements()) {
            Object value;
            String name = (String)en.nextElement();
            Object attr = this.session.getAttribute(name);
            if (!(attr instanceof Bookmarkable) || (value = ((Bookmarkable)attr).retrieveBookmarkState(levelOfDetail)) == null) continue;
            map.put(name, value);
        }
        return map;
    }

    public void restoreSessionState(Object memento) {
        if (memento == null) {
            this.state = Collections.EMPTY_MAP;
            return;
        }
        this.state = (Map)memento;
        Iterator it = this.state.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            this.restoreAttributeState(name);
        }
    }

    public void restoreAttributeState(String name) {
        Object value;
        Object attr = this.session.getAttribute(name);
        if (attr instanceof Bookmarkable && (value = this.state.get(name)) != null) {
            ((Bookmarkable)attr).setBookmarkState(value);
        }
    }
}

