/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.charset;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.charset.CharsetResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CharsetFilter
implements Filter {
    private static final Logger logger = Logger.getLogger((Class)CharsetFilter.class);
    private static final String ISO88591 = "iso-8859-1";
    private static final String UTF8 = "utf-8";
    private static String encoding = "iso-8859-1";
    private String contentType = null;

    public void init(FilterConfig fc) throws ServletException {
        Resources res = Resources.instance();
        encoding = res.getOptionalString("tbeller.charset", null);
        if (encoding == null) {
            encoding = fc.getInitParameter("encoding");
        }
        if (encoding == null) {
            encoding = UTF8;
        }
        logger.info((Object)("setting encoding to " + encoding));
        this.contentType = fc.getInitParameter("contentType");
    }

    public void destroy() {
        logger.info((Object)"setting encoding back to ISO-8859-1");
        encoding = ISO88591;
    }

    public static String getEncoding() {
        return encoding;
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, encoding);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(null, (Throwable)e);
            return s;
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding(encoding);
        }
        res = new CharsetResponse((HttpServletResponse)res, this.contentType, encoding);
        chain.doFilter(req, res);
    }
}

