/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.controller;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.controller.MultiPartEnabledRequest;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestContextFactory;
import com.tonbeller.wcf.convert.Converter;
import com.tonbeller.wcf.expr.ExprContext;
import com.tonbeller.wcf.expr.ExprUtils;
import com.tonbeller.wcf.format.Formatter;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class RequestContextImpl
extends RequestContext
implements ExprContext {
    protected RequestContextFactory rcf;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected static Logger logger = Logger.getLogger((Class)RequestContextImpl.class);

    public RequestContextImpl(RequestContextFactory rcf, HttpServletRequest request, HttpServletResponse response) {
        this.rcf = rcf;
        this.request = request;
        this.response = response;
    }

    public void invalidate() {
        super.invalidate();
        this.rcf = null;
        this.request = null;
        this.response = null;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getServletContext() {
        return this.getSession().getServletContext();
    }

    public HttpSession getSession() {
        return this.request.getSession(true);
    }

    public Locale getLocale() {
        return this.rcf.getLocale();
    }

    public Formatter getFormatter() {
        return this.rcf.getFormatter();
    }

    public Converter getConverter() {
        return this.rcf.getConverter();
    }

    public Map getParameters() {
        return this.request.getParameterMap();
    }

    public String[] getParameters(String name) {
        return this.request.getParameterValues(name);
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public Object getModelReference(String expr) {
        if (expr == null || expr.length() == 0) {
            return null;
        }
        FacesContext fc = FacesContext.getCurrentInstance();
        if (fc != null && expr.startsWith("#{")) {
            ValueBinding vb = fc.getApplication().createValueBinding(expr);
            return vb.getValue(fc);
        }
        return ExprUtils.getModelReference(this, expr);
    }

    public void setModelReference(String expr, Object value) {
        FacesContext fc = FacesContext.getCurrentInstance();
        if (fc != null && expr.startsWith("#{")) {
            ValueBinding vb = fc.getApplication().createValueBinding(expr);
            vb.setValue(fc, value);
        } else {
            ExprUtils.setModelReference(this, expr, value);
        }
    }

    public Object findBean(String name) {
        Object bean = this.request.getAttribute(name);
        if (bean != null) {
            return bean;
        }
        HttpSession session = this.getSession();
        bean = session.getAttribute(name);
        if (bean != null) {
            return bean;
        }
        ServletContext context = this.getServletContext();
        bean = context.getAttribute(name);
        if (bean != null) {
            return bean;
        }
        return null;
    }

    public void setBean(String name, Object bean) {
        HttpSession session = this.getSession();
        if (bean == null) {
            session.removeAttribute(name);
        } else {
            session.setAttribute(name, bean);
        }
    }

    public boolean isUserInRole(String roleExpr) {
        if (roleExpr == null || roleExpr.length() == 0) {
            return true;
        }
        String ref = (String)this.getModelReference(roleExpr);
        if (ref != null) {
            roleExpr = ref;
        }
        boolean success = true;
        if (roleExpr.startsWith("!")) {
            roleExpr = roleExpr.substring(1);
            success = false;
        }
        if (this.isAdmin()) {
            return success;
        }
        String mappedRole = this.getMappedRole(roleExpr);
        if (mappedRole != null) {
            roleExpr = mappedRole;
        }
        if (this.request == null) {
            return !success;
        }
        StringTokenizer st = new StringTokenizer(roleExpr, ", ", false);
        while (st.hasMoreTokens()) {
            if (!this.internalIsUserInRole(st.nextToken())) continue;
            return success;
        }
        return !success;
    }

    protected boolean internalIsUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    protected String getMappedRole(String role) {
        try {
            return this.rcf.getResources().getString("role." + role);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public Resources getResources() {
        return Resources.instance((Locale)this.getLocale());
    }

    public Resources getResources(String bundleName) {
        return Resources.instance((Locale)this.getLocale(), (String)bundleName);
    }

    public Resources getResources(Class clasz) {
        return Resources.instance((Locale)this.getLocale(), (Class)clasz);
    }

    public String getRemoteUser() {
        return this.rcf.getRemoteUser();
    }

    public String getRemoteDomain() {
        return this.rcf.getRemoteDomain();
    }

    public boolean isAdmin() {
        return false;
    }

    public void setLocale(Locale locale) {
        this.rcf.setLocale(this.request, locale);
    }

    public Map getFileParameters() {
        if (this.request instanceof MultiPartEnabledRequest) {
            return ((MultiPartEnabledRequest)this.request).getFileParameterMap();
        }
        return null;
    }
}

