/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.convert;

import com.tonbeller.wcf.convert.ConvertException;
import com.tonbeller.wcf.convert.NodeConverterBase;
import com.tonbeller.wcf.format.FormatException;
import com.tonbeller.wcf.format.FormatHandler;
import com.tonbeller.wcf.format.Formatter;
import com.tonbeller.wcf.ui.Item;
import com.tonbeller.wcf.ui.Select;
import com.tonbeller.wcf.utils.DomUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public abstract class SelectConverterBase
extends NodeConverterBase {
    private static Logger logger = Logger.getLogger((Class)SelectConverterBase.class);

    public void convert(Formatter fmt, Map params, Map fileSource, Element elem, Object bean) throws ConvertException, FormatException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (Select.isDisabled(elem)) {
            return;
        }
        String id = Select.getId(elem);
        Object inputAvail = params.get(id + ".valid");
        if (inputAvail == null) {
            return;
        }
        String[] values = (String[])params.get(id);
        if (values == null) {
            values = new String[]{};
        }
        DomUtils.removeAttribute(elem, "error");
        List items = Select.getItems(elem);
        Iterator it = items.iterator();
        while (it.hasNext()) {
            Item.setSelected((Element)it.next(), false);
        }
        List selected = this.selectListItems(elem, values, items);
        this.updateModelReference(fmt, elem, bean);
    }

    List selectListItems(Element elem, String[] values, List items) throws ConvertException {
        ArrayList<Element> selected = new ArrayList<Element>();
        for (int i = 0; i < values.length; ++i) {
            String itemId = values[i];
            boolean found = false;
            Iterator it = items.iterator();
            while (it.hasNext()) {
                Element item = (Element)it.next();
                if (!Item.getId(item).equals(itemId)) continue;
                Item.setSelected(item, true);
                selected.add(item);
                found = true;
                break;
            }
            if (found) continue;
            String mesg = "Item with id=\"" + itemId + "\" not found in ListBox";
            this.showMissing(elem, mesg);
        }
        return selected;
    }

    protected abstract void updateModelReference(Formatter var1, Element var2, Object var3) throws FormatException, IllegalAccessException, NoSuchMethodException, InvocationTargetException;

    public void convert(Formatter fmt, Object bean, Element elem) throws ConvertException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String modelReference = Select.getModelReference(elem);
        if (modelReference.length() == 0) {
            return;
        }
        String type = Select.getType(elem);
        String formatString = Select.getFormatString(elem);
        FormatHandler handler = fmt.getHandler(type);
        if (handler == null) {
            throw new FormatException("no handler found for type: " + type);
        }
        Object o = PropertyUtils.getProperty((Object)bean, (String)modelReference);
        Object[] values = handler.toObjectArray(o);
        if (values == null) {
            values = new Object[]{};
        }
        List items = Select.getItems(elem);
        Iterator it = items.iterator();
        while (it.hasNext()) {
            Item.setSelected((Element)it.next(), false);
        }
        for (int i = 0; i < values.length; ++i) {
            Object beanValue = values[i];
            boolean found = false;
            Iterator it2 = items.iterator();
            while (it2.hasNext()) {
                Element item = (Element)it2.next();
                Object itemValue = handler.parse(Item.getValue(item), formatString);
                if (!itemValue.equals(beanValue)) continue;
                Item.setSelected(item, true);
                found = true;
                break;
            }
            if (found) continue;
            String mesg = "No item has a value of \"" + beanValue + "\".";
            this.showMissing(elem, mesg);
        }
    }

    private void showMissing(Element elem, String mesg) {
        boolean soft = "true".equals(elem.getAttribute("ignore-missing"));
        if (!soft) {
            throw new ConvertException(mesg);
        }
        logger.warn((Object)mesg);
    }
}

