/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.scroller;

import com.tonbeller.wcf.controller.RequestContext;
import java.io.IOException;
import javax.servlet.jsp.JspWriter;

public class Scroller {
    private static String SCROLLER_KEY = Scroller.class.getName();
    public static final String FORCE_SCROLLER = "forcescroller";

    public void handleRequest(RequestContext context, JspWriter out) throws IOException {
        this.writeCoordParam(context, out, "wcfXCoord");
        this.writeCoordParam(context, out, "wcfYCoord");
    }

    private void writeCoordParam(RequestContext context, JspWriter out, String coordName) throws IOException {
        String val;
        String coordVal = "0";
        if (Scroller.isScrollerEnabled(context) && (val = context.getParameter(coordName)) != null) {
            coordVal = val;
        }
        out.print("<input type=\"hidden\" name=\"" + coordName + "\" value=\"" + coordVal + "\"/>");
    }

    public static void enableScroller(RequestContext context) {
        if (Scroller.isScrollerEnabled(context)) {
            return;
        }
        context.getRequest().setAttribute(SCROLLER_KEY, (Object)"true");
    }

    public static boolean isScrollerEnabled(RequestContext context) {
        if (context.getParameter(FORCE_SCROLLER) != null) {
            return true;
        }
        return context.getRequest().getAttribute(SCROLLER_KEY) != null;
    }
}

