/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.table;

import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.format.FormatException;
import com.tonbeller.wcf.format.FormatHandler;
import com.tonbeller.wcf.format.Formatter;
import com.tonbeller.wcf.table.CellRenderer;
import com.tonbeller.wcf.table.DefaultCell;
import com.tonbeller.wcf.utils.DomUtils;
import org.w3c.dom.Element;

public class DefaultCellRenderer
implements CellRenderer {
    Alignment alignment = Alignment.GUESS;
    String format;
    String type;
    private static final String NBSP = "\u00a0";

    public void render(RequestContext context, Element td, Object value) throws FormatException {
        Element elem = td;
        boolean needSpace = true;
        if (value instanceof DefaultCell) {
            DefaultCell hc = (DefaultCell)value;
            value = hc.getValue();
            if (hc.getURL() != null) {
                elem = DomUtils.appendElement(elem, "a");
                elem.setAttribute("href", hc.getURL());
                if (hc.getTarget() != null) {
                    elem.setAttribute("target", hc.getTarget());
                }
                if (hc.getOnClick() != null) {
                    elem.setAttribute("onClick", hc.getOnClick());
                }
            }
            if (hc.getImage() != null) {
                Element img = DomUtils.appendElement(elem, "img");
                img.setAttribute("border", "0");
                img.setAttribute("src", hc.getImage());
                DomUtils.appendText(elem, " ");
                needSpace = false;
            }
        }
        if (value != null) {
            String s;
            Formatter fmt = context.getFormatter();
            FormatHandler fh = null;
            if (this.type != null) {
                fh = fmt.getHandler(this.type);
            }
            if (fh == null) {
                fh = fmt.guessHandler(value);
            }
            if ((s = fh != null ? fh.format(value, this.format) : (value != null ? value.toString() : null)) == null || s.length() == 0 || s.trim().length() == 0) {
                s = NBSP;
            }
            DomUtils.appendText(elem, s);
            if (this.alignment == Alignment.GUESS) {
                if (value instanceof Number) {
                    td.setAttribute("align", "right");
                } else {
                    td.setAttribute("align", "left");
                }
            } else {
                td.setAttribute("align", this.alignment.getAttributeValue());
            }
        } else if (needSpace) {
            DomUtils.setText(elem, NBSP);
        }
    }

    public void setFormat(String newFormat) {
        this.format = newFormat;
    }

    public String getFormat() {
        return this.format;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public String getType() {
        return this.type;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public static class Alignment {
        public static final Alignment GUESS = new Alignment("");
        public static final Alignment LEFT = new Alignment("left");
        public static final Alignment RIGHT = new Alignment("right");
        private String attributeValue;

        private Alignment(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        public String getAttributeValue() {
            return this.attributeValue;
        }
    }
}

