/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.table;

import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.form.FormComponent;
import com.tonbeller.wcf.form.NodeHandlerSupport;
import com.tonbeller.wcf.form.XmlComponent;
import com.tonbeller.wcf.selection.DefaultSelectionModel;
import com.tonbeller.wcf.selection.SelectionChangeListener;
import com.tonbeller.wcf.table.TableComponent;
import com.tonbeller.wcf.table.TableModel;
import com.tonbeller.wcf.ui.XoplonCtrl;
import com.tonbeller.wcf.utils.DomUtils;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.PropertyUtils;
import org.w3c.dom.Element;

public class TableHandler
extends NodeHandlerSupport {
    TableComponent table;
    FormComponent formComp;

    public void initialize(RequestContext context, XmlComponent xmlComp, Element element) throws Exception {
        String width;
        super.initialize(context, xmlComp, element);
        this.formComp = (FormComponent)xmlComp;
        String ref = XoplonCtrl.getModelReference(element);
        Object bean = this.formComp.getBean();
        TableModel tm = (TableModel)PropertyUtils.getProperty((Object)bean, (String)ref);
        this.table = this.createTableComp(element.getAttribute("id"), this.formComp, tm);
        DefaultSelectionModel dsm = new DefaultSelectionModel();
        String selmode = element.getAttribute("selmode");
        if ("href".equals(selmode)) {
            dsm.setMode(3);
        } else if ("single".equals(selmode)) {
            dsm.setMode(1);
        } else if ("multi".equals(selmode)) {
            dsm.setMode(2);
        } else {
            dsm.setMode(0);
        }
        this.table.setSelectionModel(dsm);
        if (tm instanceof SelectionChangeListener) {
            dsm.addSelectionListener((SelectionChangeListener)((Object)tm));
        }
        this.table.setClosable(false);
        String border = element.getAttribute("border");
        if (border.length() > 0) {
            this.table.setBorder(border);
        }
        if ((width = element.getAttribute("width")).length() > 0) {
            this.table.setWidth(width);
        }
        if ("false".equals(element.getAttribute("colHeaders"))) {
            this.table.setColHeaders(false);
        }
        this.table.setRenderId(element.getAttribute("id"));
        this.table.addFormListener(this.formComp);
        this.formComp.addFormListener(this.table);
        this.table.initialize(context);
    }

    protected TableComponent createTableComp(String id, FormComponent comp, TableModel tm) {
        return new TableComponent(id, this.formComp, tm);
    }

    public void destroy(HttpSession session) throws Exception {
        this.table.destroy(session);
        super.destroy(session);
    }

    public void render(RequestContext context) throws Exception {
        super.render(context);
        Element parent = this.getElement();
        DomUtils.removeChildElements(parent);
        Element child = this.table.render(context, parent.getOwnerDocument());
        parent.appendChild(child);
    }

    public FormComponent getFormComp() {
        return this.formComp;
    }

    public TableComponent getTable() {
        return this.table;
    }
}

