/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.utils;

import com.tonbeller.wcf.utils.SoftException;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    private static final String WEBKEY = XmlUtils.class.getName();
    private static Logger logger = Logger.getLogger((Class)XmlUtils.class);
    private Hashtable templatesCache = new Hashtable();

    private XmlUtils() {
    }

    public Transformer getTransformer(ServletContext ctx, String xslUri, boolean xslCache) {
        Hashtable hashtable = this.templatesCache;
        synchronized (hashtable) {
            try {
                Templates templates = null;
                if (xslCache) {
                    templates = (Templates)this.templatesCache.get(xslUri);
                }
                if (templates == null) {
                    TransformerFactory tf = TransformerFactory.newInstance();
                    URL url = ctx.getResource(xslUri);
                    if (url == null) {
                        throw new IllegalArgumentException("stylesheet \"" + xslUri + "\" not found");
                    }
                    StreamSource ss = new StreamSource(url.getFile());
                    templates = tf.newTemplates(ss);
                    if (xslCache) {
                        this.templatesCache.put(xslUri, templates);
                    }
                }
                return templates.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new SoftException(e);
            }
            catch (MalformedURLException e) {
                throw new SoftException(e);
            }
        }
    }

    public static Transformer getTransformer(HttpSession session, String xslUri, boolean xslCache) {
        return XmlUtils.instance(session).getTransformer(session.getServletContext(), xslUri, xslCache);
    }

    public static DocumentBuilder getParser() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setExpandEntityReferences(true);
            return dbf.newDocumentBuilder();
        }
        catch (FactoryConfigurationError e) {
            throw new SoftException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SoftException(e);
        }
    }

    public static Document createDocument() {
        try {
            return XmlUtils.getParser().newDocument();
        }
        catch (FactoryConfigurationError e) {
            throw new SoftException(e);
        }
    }

    public static void print(Node node, Writer out, Properties p) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            DOMSource src = new DOMSource(node);
            StreamResult dest = new StreamResult(out);
            Transformer t = tf.newTransformer();
            if (p != null) {
                t.setOutputProperties(p);
            }
            t.transform(src, dest);
        }
        catch (TransformerConfigurationException e) {
            throw new SoftException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new SoftException(e);
        }
        catch (TransformerException e) {
            throw new SoftException(e);
        }
    }

    public static void print(Node node, Writer out) {
        XmlUtils.print(node, out, null);
    }

    public static synchronized XmlUtils instance(HttpSession session) {
        XmlUtils service = (XmlUtils)session.getAttribute(WEBKEY);
        if (service == null) {
            service = new XmlUtils();
            session.setAttribute(WEBKEY, (Object)service);
        }
        return service;
    }

    public static Document getDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    public static Document parse(URL url) {
        try {
            InputSource src = new InputSource(url.toExternalForm());
            return XmlUtils.getParser().parse(src);
        }
        catch (IOException e) {
            throw new SoftException(e);
        }
        catch (SAXException e) {
            throw new SoftException(e);
        }
    }

    public static String escapeXml(String s) {
        if (s == null) {
            return null;
        }
        char[] arr = s.toCharArray();
        StringBuffer sb = new StringBuffer();
        block6: for (int i = 0; i < arr.length; ++i) {
            switch (arr[i]) {
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(arr[i]);
                }
            }
        }
        return sb.toString();
    }
}

