/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MetaNodeTracker;
import org.apache.hadoop.hbase.zookeeper.RootRegionTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.ipc.RemoteException;

public class CatalogTracker {
    private static final Log LOG = LogFactory.getLog(CatalogTracker.class);
    private final HConnection connection;
    private final ZooKeeperWatcher zookeeper;
    private final RootRegionTracker rootRegionTracker;
    private final MetaNodeTracker metaNodeTracker;
    private final AtomicBoolean metaAvailable = new AtomicBoolean(false);
    private boolean instantiatedzkw = false;
    private Abortable abortable;
    private ServerName metaLocation;
    private volatile boolean stopped = false;
    static final byte[] ROOT_REGION_NAME = HRegionInfo.ROOT_REGIONINFO.getRegionName();
    static final byte[] META_REGION_NAME = HRegionInfo.FIRST_META_REGIONINFO.getRegionName();

    public CatalogTracker(Configuration conf) throws IOException {
        this(null, conf, null);
    }

    public CatalogTracker(ZooKeeperWatcher zk, Configuration conf, Abortable abortable) throws IOException {
        this(zk, conf, HConnectionManager.getConnection(conf), abortable);
    }

    CatalogTracker(ZooKeeperWatcher zk, Configuration conf, HConnection connection, Abortable abortable) throws IOException {
        this.connection = connection;
        if (abortable == null) {
            this.abortable = this.connection;
        }
        Abortable throwableAborter = new Abortable(){

            @Override
            public void abort(String why, Throwable e) {
                throw new RuntimeException(why, e);
            }

            @Override
            public boolean isAborted() {
                return true;
            }
        };
        if (zk == null) {
            this.zookeeper = new ZooKeeperWatcher(conf, "catalogtracker-on-" + connection.toString(), abortable);
            this.instantiatedzkw = true;
        } else {
            this.zookeeper = zk;
        }
        this.rootRegionTracker = new RootRegionTracker(this.zookeeper, throwableAborter);
        final CatalogTracker ct = this;
        this.metaNodeTracker = new MetaNodeTracker(this.zookeeper, throwableAborter){

            @Override
            public void nodeDeleted(String path) {
                if (!path.equals(this.node)) {
                    return;
                }
                ct.resetMetaLocation();
            }
        };
    }

    public void start() throws IOException, InterruptedException {
        LOG.debug((Object)("Starting catalog tracker " + this));
        try {
            this.rootRegionTracker.start();
            this.metaNodeTracker.start();
        }
        catch (RuntimeException e) {
            Throwable t = e.getCause();
            this.abortable.abort(e.getMessage(), t);
            throw new IOException("Attempt to start root/meta tracker failed.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.stopped) {
            LOG.debug((Object)("Stopping catalog tracker " + this));
            this.stopped = true;
            this.rootRegionTracker.stop();
            this.metaNodeTracker.stop();
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Attempt to close catalog tracker's connection failed.", (Throwable)e);
            }
            if (this.instantiatedzkw) {
                this.zookeeper.close();
            }
            AtomicBoolean atomicBoolean = this.metaAvailable;
            synchronized (atomicBoolean) {
                this.metaAvailable.notifyAll();
            }
        }
    }

    public ServerName getRootLocation() throws InterruptedException {
        return this.rootRegionTracker.getRootRegionLocation();
    }

    public ServerName getMetaLocation() {
        return this.metaLocation;
    }

    public ServerName getMetaLocationOrReadLocationFromRoot() throws IOException {
        ServerName sn = this.getMetaLocation();
        return sn != null ? sn : MetaReader.getMetaRegionLocation(this);
    }

    public void waitForRoot() throws InterruptedException {
        this.rootRegionTracker.blockUntilAvailable();
    }

    ServerName waitForRoot(long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException {
        ServerName sn = this.rootRegionTracker.waitRootRegionLocation(timeout);
        if (sn == null) {
            throw new NotAllMetaRegionsOnlineException("Timed out; " + timeout + "ms");
        }
        return sn;
    }

    public HRegionInterface waitForRootServerConnection(long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException, IOException {
        return this.getRootServerConnection(timeout);
    }

    HRegionInterface getRootServerConnection(long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException, IOException {
        return this.getCachedConnection(this.waitForRoot(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HRegionInterface getMetaServerConnection() throws IOException, InterruptedException {
        AtomicBoolean atomicBoolean = this.metaAvailable;
        synchronized (atomicBoolean) {
            ServerName newLocation;
            if (this.metaAvailable.get()) {
                HRegionInterface current = this.getCachedConnection(this.metaLocation);
                if (this.verifyRegionLocation(current, this.metaLocation, META_REGION_NAME)) {
                    return current;
                }
                this.resetMetaLocation();
            }
            if ((newLocation = MetaReader.getMetaRegionLocation(this)) == null) {
                return null;
            }
            HRegionInterface newConnection = this.getCachedConnection(newLocation);
            if (this.verifyRegionLocation(newConnection, newLocation, META_REGION_NAME)) {
                this.setMetaLocation(newLocation);
                return newConnection;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("New .META. server: " + newLocation + " isn't valid." + " Cached .META. server: " + this.metaLocation));
            }
            return null;
        }
    }

    public void waitForMeta() throws InterruptedException {
        while (!this.stopped) {
            try {
                if (this.waitForMeta(100L) == null) continue;
                break;
            }
            catch (NotAllMetaRegionsOnlineException e) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.info((Object)(".META. still not available, sleeping and retrying. Reason: " + e.getMessage()));
            }
            catch (IOException e) {
                LOG.info((Object)"Retrying", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerName waitForMeta(long timeout) throws InterruptedException, IOException, NotAllMetaRegionsOnlineException {
        long stop = timeout == 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeout;
        long waitTime = Math.min(50L, timeout);
        AtomicBoolean atomicBoolean = this.metaAvailable;
        synchronized (atomicBoolean) {
            while (!this.stopped && System.currentTimeMillis() < stop) {
                if (this.getMetaServerConnection() != null) {
                    return this.metaLocation;
                }
                this.metaAvailable.wait(waitTime);
            }
            if (this.getMetaServerConnection() == null) {
                throw new NotAllMetaRegionsOnlineException("Timed out (" + timeout + "ms)");
            }
            return this.metaLocation;
        }
    }

    public HRegionInterface waitForMetaServerConnection(long timeout) throws InterruptedException, NotAllMetaRegionsOnlineException, IOException {
        return this.getCachedConnection(this.waitForMeta(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMetaLocation() {
        LOG.debug((Object)("Current cached META location, " + this.metaLocation + ", is not valid, resetting"));
        AtomicBoolean atomicBoolean = this.metaAvailable;
        synchronized (atomicBoolean) {
            this.metaAvailable.set(false);
            this.metaAvailable.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMetaLocation(ServerName metaLocation) {
        LOG.debug((Object)("Set new cached META location: " + metaLocation));
        AtomicBoolean atomicBoolean = this.metaAvailable;
        synchronized (atomicBoolean) {
            this.metaLocation = metaLocation;
            this.metaAvailable.set(true);
            this.metaAvailable.notifyAll();
        }
    }

    private HRegionInterface getCachedConnection(ServerName sn) throws IOException {
        HRegionInterface protocol;
        block9: {
            if (sn == null) {
                return null;
            }
            protocol = null;
            try {
                protocol = this.connection.getHRegionConnection(sn.getHostname(), sn.getPort());
            }
            catch (RetriesExhaustedException e) {
                if (e.getCause() == null || !(e.getCause() instanceof ConnectException)) {
                    throw e;
                }
            }
            catch (SocketTimeoutException e) {
                LOG.debug((Object)("Timed out connecting to " + sn));
            }
            catch (NoRouteToHostException e) {
                LOG.debug((Object)("Connecting to " + sn), (Throwable)e);
            }
            catch (SocketException e) {
                LOG.debug((Object)("Exception connecting to " + sn));
            }
            catch (UnknownHostException e) {
                LOG.debug((Object)("Unknown host exception connecting to  " + sn));
            }
            catch (IOException ioe) {
                Throwable cause = ioe.getCause();
                if (ioe instanceof ConnectException || cause != null && cause instanceof EOFException || cause != null && cause.getMessage() != null && cause.getMessage().toLowerCase().contains("connection reset")) break block9;
                throw ioe;
            }
        }
        return protocol;
    }

    private boolean verifyRegionLocation(HRegionInterface hostingServer, ServerName address, byte[] regionName) throws IOException {
        if (hostingServer == null) {
            LOG.info((Object)"Passed hostingServer is null");
            return false;
        }
        Throwable t = null;
        try {
            return hostingServer.getRegionInfo(regionName) != null;
        }
        catch (ConnectException e) {
            t = e;
        }
        catch (RetriesExhaustedException e) {
            t = e;
        }
        catch (RemoteException e) {
            IOException ioe = e.unwrapRemoteException();
            t = ioe;
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            t = cause != null && cause instanceof EOFException ? cause : (cause != null && cause.getMessage() != null && cause.getMessage().contains("Connection reset") ? cause : e);
        }
        LOG.info((Object)("Failed verification of " + Bytes.toStringBinary(regionName) + " at address=" + address + "; " + t));
        return false;
    }

    public boolean verifyRootRegionLocation(long timeout) throws InterruptedException, IOException {
        HRegionInterface connection = null;
        try {
            connection = this.waitForRootServerConnection(timeout);
        }
        catch (NotAllMetaRegionsOnlineException e) {
        }
        catch (ServerNotRunningYetException e) {
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        return connection == null ? false : this.verifyRegionLocation(connection, this.rootRegionTracker.getRootRegionLocation(), ROOT_REGION_NAME);
    }

    public boolean verifyMetaRegionLocation(long timeout) throws InterruptedException, IOException {
        HRegionInterface connection = null;
        try {
            connection = this.waitForMetaServerConnection(timeout);
        }
        catch (NotAllMetaRegionsOnlineException e) {
        }
        catch (ServerNotRunningYetException e) {
        }
        catch (UnknownHostException e) {
        }
        catch (RetriesExhaustedException e) {
            LOG.debug((Object)"Failed verify meta region location after retries", (Throwable)e);
        }
        return connection != null;
    }

    MetaNodeTracker getMetaNodeTracker() {
        return this.metaNodeTracker;
    }

    public HConnection getConnection() {
        return this.connection;
    }
}

