/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class ColumnRangeFilter
extends FilterBase {
    protected byte[] minColumn = null;
    protected boolean minColumnInclusive = true;
    protected byte[] maxColumn = null;
    protected boolean maxColumnInclusive = false;

    public ColumnRangeFilter() {
    }

    public ColumnRangeFilter(byte[] minColumn, boolean minColumnInclusive, byte[] maxColumn, boolean maxColumnInclusive) {
        this.minColumn = minColumn;
        this.minColumnInclusive = minColumnInclusive;
        this.maxColumn = maxColumn;
        this.maxColumnInclusive = maxColumnInclusive;
    }

    public boolean isMinColumnInclusive() {
        return this.minColumnInclusive;
    }

    public boolean isMaxColumnInclusive() {
        return this.maxColumnInclusive;
    }

    public byte[] getMinColumn() {
        return this.minColumn;
    }

    public boolean getMinColumnInclusive() {
        return this.minColumnInclusive;
    }

    public byte[] getMaxColumn() {
        return this.maxColumn;
    }

    public boolean getMaxColumnInclusive() {
        return this.maxColumnInclusive;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue kv) {
        byte[] buffer = kv.getBuffer();
        int qualifierOffset = kv.getQualifierOffset();
        int qualifierLength = kv.getQualifierLength();
        int cmpMin = 1;
        if (this.minColumn != null) {
            cmpMin = Bytes.compareTo(buffer, qualifierOffset, qualifierLength, this.minColumn, 0, this.minColumn.length);
        }
        if (cmpMin < 0) {
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        if (!this.minColumnInclusive && cmpMin == 0) {
            return Filter.ReturnCode.SKIP;
        }
        if (this.maxColumn == null) {
            return Filter.ReturnCode.INCLUDE;
        }
        int cmpMax = Bytes.compareTo(buffer, qualifierOffset, qualifierLength, this.maxColumn, 0, this.maxColumn.length);
        if (this.maxColumnInclusive && cmpMax <= 0 || !this.maxColumnInclusive && cmpMax < 0) {
            return Filter.ReturnCode.INCLUDE;
        }
        return Filter.ReturnCode.NEXT_ROW;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 4 ? 1 : 0) != 0, (String)"Expected 4 but got: %s", (Object[])new Object[]{filterArguments.size()});
        byte[] minColumn = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        boolean minColumnInclusive = ParseFilter.convertByteArrayToBoolean(filterArguments.get(1));
        byte[] maxColumn = ParseFilter.removeQuotesFromByteArray(filterArguments.get(2));
        boolean maxColumnInclusive = ParseFilter.convertByteArrayToBoolean(filterArguments.get(3));
        if (minColumn.length == 0) {
            minColumn = null;
        }
        if (maxColumn.length == 0) {
            maxColumn = null;
        }
        return new ColumnRangeFilter(minColumn, minColumnInclusive, maxColumn, maxColumnInclusive);
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.minColumn == null);
        Bytes.writeByteArray(out, this.minColumn);
        out.writeBoolean(this.minColumnInclusive);
        out.writeBoolean(this.maxColumn == null);
        Bytes.writeByteArray(out, this.maxColumn);
        out.writeBoolean(this.maxColumnInclusive);
    }

    public void readFields(DataInput in) throws IOException {
        boolean isMinColumnNull = in.readBoolean();
        this.minColumn = Bytes.readByteArray(in);
        if (isMinColumnNull) {
            this.minColumn = null;
        }
        this.minColumnInclusive = in.readBoolean();
        boolean isMaxColumnNull = in.readBoolean();
        this.maxColumn = Bytes.readByteArray(in);
        if (isMaxColumnNull) {
            this.maxColumn = null;
        }
        this.maxColumnInclusive = in.readBoolean();
    }

    @Override
    public KeyValue getNextKeyHint(KeyValue kv) {
        return KeyValue.createFirstOnRow(kv.getBuffer(), kv.getRowOffset(), kv.getRowLength(), kv.getBuffer(), kv.getFamilyOffset(), kv.getFamilyLength(), this.minColumn, 0, this.minColumn == null ? 0 : this.minColumn.length);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + (this.minColumnInclusive ? "[" : "(") + Bytes.toStringBinary(this.minColumn) + ", " + Bytes.toStringBinary(this.maxColumn) + (this.maxColumnInclusive ? "]" : ")");
    }
}

