/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.BulkAssigner;
import org.apache.hadoop.hbase.master.RegionPlan;

public class BulkReOpen
extends BulkAssigner {
    private final Map<ServerName, List<HRegionInfo>> rsToRegions;
    private final AssignmentManager assignmentManager;
    private static final Log LOG = LogFactory.getLog(BulkReOpen.class);

    public BulkReOpen(Server server, Map<ServerName, List<HRegionInfo>> serverToRegions, AssignmentManager am) {
        super(server);
        this.assignmentManager = am;
        this.rsToRegions = serverToRegions;
    }

    @Override
    protected void populatePool(ExecutorService pool) {
        LOG.debug((Object)"Creating threads for each region server ");
        for (Map.Entry<ServerName, List<HRegionInfo>> e : this.rsToRegions.entrySet()) {
            final List<HRegionInfo> hris = e.getValue();
            HashMap<String, RegionPlan> plans = new HashMap<String, RegionPlan>();
            for (HRegionInfo hri : hris) {
                RegionPlan reOpenPlan = new RegionPlan(hri, null, this.assignmentManager.getRegionServerOfRegion(hri));
                plans.put(hri.getEncodedName(), reOpenPlan);
            }
            this.assignmentManager.addPlans(plans);
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    BulkReOpen.this.assignmentManager.unassign(hris);
                }
            });
        }
    }

    @Override
    protected boolean waitUntilDone(long timeout) {
        return true;
    }

    @Override
    protected int getThreadCount() {
        int defaultThreadCount = super.getThreadCount();
        return this.server.getConfiguration().getInt("hbase.bulk.reopen.threadpool.size", defaultThreadCount);
    }

    public boolean bulkReOpen() throws InterruptedException, IOException {
        return this.bulkAssign();
    }
}

