/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.ServerCommandLine;

public class HRegionServerCommandLine
extends ServerCommandLine {
    private static final Log LOG = LogFactory.getLog(HRegionServerCommandLine.class);
    private final Class<? extends HRegionServer> regionServerClass;
    private static final String USAGE = "Usage: HRegionServer [-D conf.param=value] start";

    public HRegionServerCommandLine(Class<? extends HRegionServer> clazz) {
        this.regionServerClass = clazz;
    }

    @Override
    protected String getUsage() {
        return USAGE;
    }

    private int start() throws Exception {
        Configuration conf = this.getConf();
        try {
            if (LocalHBaseCluster.isLocal(conf)) {
                LOG.warn((Object)"Not starting a distinct region server because hbase.cluster.distributed is false");
            } else {
                HRegionServerCommandLine.logJVMInfo();
                HRegionServer hrs = HRegionServer.constructRegionServer(this.regionServerClass, conf);
                Thread rsThread = HRegionServer.startRegionServer(hrs);
                rsThread.join();
                if (hrs.isAborted()) {
                    throw new RuntimeException("HRegionServer Aborted");
                }
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Region server exiting", t);
            return 1;
        }
        return 0;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 1) {
            this.usage(null);
            return 1;
        }
        String cmd = args[0];
        if ("start".equals(cmd)) {
            return this.start();
        }
        if ("stop".equals(cmd)) {
            System.err.println("To shutdown the regionserver run bin/hbase-daemon.sh stop regionserver or send a kill signal tothe regionserver pid");
            return 1;
        }
        this.usage("Unknown command: " + args[0]);
        return 1;
    }
}

