/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.regionserver.ReplicationSinkService;
import org.apache.hadoop.hbase.regionserver.ReplicationSourceService;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationZookeeper;
import org.apache.hadoop.hbase.replication.master.ReplicationLogCleaner;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSink;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.zookeeper.KeeperException;

public class Replication
implements WALActionsListener,
ReplicationSourceService,
ReplicationSinkService {
    private static final Log LOG = LogFactory.getLog(Replication.class);
    private boolean replication;
    private ReplicationSourceManager replicationManager;
    private final AtomicBoolean replicating = new AtomicBoolean(true);
    private ReplicationZookeeper zkHelper;
    private Configuration conf;
    private ReplicationSink replicationSink;
    private Server server;
    private ScheduledExecutorService scheduleThreadPool;
    private int statsThreadPeriod;

    public Replication(Server server, FileSystem fs, Path logDir, Path oldLogDir) throws IOException {
        this.initialize(server, fs, logDir, oldLogDir);
    }

    public Replication() {
    }

    @Override
    public void initialize(Server server, FileSystem fs, Path logDir, Path oldLogDir) throws IOException {
        this.server = server;
        this.conf = this.server.getConfiguration();
        this.replication = Replication.isReplication(this.conf);
        this.scheduleThreadPool = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat(server.getServerName() + "Replication Statistics #%d").setDaemon(true).build());
        if (this.replication) {
            try {
                this.zkHelper = new ReplicationZookeeper(server, this.replicating);
            }
            catch (KeeperException ke) {
                throw new IOException("Failed replication handler create (replicating=" + this.replicating, ke);
            }
            this.replicationManager = new ReplicationSourceManager(this.zkHelper, this.conf, this.server, fs, this.replicating, logDir, oldLogDir);
            this.statsThreadPeriod = this.conf.getInt("replication.stats.thread.period.seconds", 300);
            LOG.debug((Object)("ReplicationStatisticsThread " + this.statsThreadPeriod));
        } else {
            this.replicationManager = null;
            this.zkHelper = null;
        }
    }

    public static boolean isReplication(Configuration c) {
        return c.getBoolean("hbase.replication", false);
    }

    @Override
    public WALActionsListener getWALActionsListener() {
        return this;
    }

    @Override
    public void stopReplicationService() {
        this.join();
    }

    public void join() {
        if (this.replication) {
            this.replicationManager.join();
            if (this.replicationSink != null) {
                this.replicationSink.stopReplicationSinkServices();
            }
        }
    }

    @Override
    public void replicateLogEntries(HLog.Entry[] entries) throws IOException {
        if (this.replication) {
            this.replicationSink.replicateEntries(entries);
        }
    }

    @Override
    public void startReplicationService() throws IOException {
        if (this.replication) {
            this.replicationManager.init();
            this.replicationSink = new ReplicationSink(this.conf, this.server);
            this.scheduleThreadPool.scheduleAtFixedRate(new ReplicationStatisticsThread(this.replicationSink, this.replicationManager), this.statsThreadPeriod, this.statsThreadPeriod, TimeUnit.SECONDS);
        }
    }

    public ReplicationSourceManager getReplicationManager() {
        return this.replicationManager;
    }

    @Override
    public void visitLogEntryBeforeWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit) {
    }

    @Override
    public void visitLogEntryBeforeWrite(HTableDescriptor htd, HLogKey logKey, WALEdit logEdit) {
        for (KeyValue kv : logEdit.getKeyValues()) {
            byte[] family = kv.getFamily();
            int scope = htd.getFamily(family).getScope();
            if (scope == 0 || logEdit.hasKeyInScope(family)) continue;
            logEdit.putIntoScope(family, scope);
        }
    }

    @Override
    public void preLogRoll(Path oldPath, Path newPath) throws IOException {
        this.getReplicationManager().preLogRoll(newPath);
    }

    @Override
    public void postLogRoll(Path oldPath, Path newPath) throws IOException {
        this.getReplicationManager().postLogRoll(newPath);
    }

    @Override
    public void preLogArchive(Path oldPath, Path newPath) throws IOException {
    }

    @Override
    public void postLogArchive(Path oldPath, Path newPath) throws IOException {
    }

    public static void decorateMasterConfiguration(Configuration conf) {
        String cleanerClass;
        if (!Replication.isReplication(conf)) {
            return;
        }
        String plugins = conf.get("hbase.master.logcleaner.plugins");
        if (!plugins.contains(cleanerClass = ReplicationLogCleaner.class.getCanonicalName())) {
            conf.set("hbase.master.logcleaner.plugins", plugins + "," + cleanerClass);
        }
    }

    @Override
    public void logRollRequested() {
    }

    @Override
    public void logCloseRequested() {
    }

    static class ReplicationStatisticsThread
    extends Thread {
        private final ReplicationSink replicationSink;
        private final ReplicationSourceManager replicationManager;

        public ReplicationStatisticsThread(ReplicationSink replicationSink, ReplicationSourceManager replicationManager) {
            super("ReplicationStatisticsThread");
            this.replicationManager = replicationManager;
            this.replicationSink = replicationSink;
        }

        @Override
        public void run() {
            this.printStats(this.replicationManager.getStats());
            this.printStats(this.replicationSink.getStats());
        }

        private void printStats(String stats) {
            if (!stats.isEmpty()) {
                LOG.info((Object)stats);
            }
        }
    }
}

