/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.metrics;

import org.apache.hadoop.hbase.metrics.MetricsRate;
import org.apache.hadoop.hbase.rest.metrics.RESTStatistics;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.jvm.JvmMetrics;
import org.apache.hadoop.metrics.util.MetricsRegistry;

public class RESTMetrics
implements Updater {
    private final MetricsRecord metricsRecord;
    private final MetricsRegistry registry = new MetricsRegistry();
    private final RESTStatistics restStatistics;
    private MetricsRate requests = new MetricsRate("requests", this.registry);
    private MetricsRate sucessfulGetCount = new MetricsRate("sucessful.get.count", this.registry);
    private MetricsRate sucessfulPutCount = new MetricsRate("sucessful.put.count", this.registry);
    private MetricsRate sucessfulDeleteCount = new MetricsRate("sucessful.delete.count", this.registry);
    private MetricsRate failedGetCount = new MetricsRate("failed.get.count", this.registry);
    private MetricsRate failedPutCount = new MetricsRate("failed.put.count", this.registry);
    private MetricsRate failedDeleteCount = new MetricsRate("failed.delete.count", this.registry);

    public RESTMetrics() {
        MetricsContext context = MetricsUtil.getContext((String)"rest");
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)context, (String)"rest");
        String name = Thread.currentThread().getName();
        this.metricsRecord.setTag("REST", name);
        context.registerUpdater((Updater)this);
        JvmMetrics.init((String)"rest", (String)name);
        this.restStatistics = new RESTStatistics(this.registry);
    }

    public void shutdown() {
        if (this.restStatistics != null) {
            this.restStatistics.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext unused) {
        RESTMetrics rESTMetrics = this;
        synchronized (rESTMetrics) {
            this.requests.pushMetric(this.metricsRecord);
            this.sucessfulGetCount.pushMetric(this.metricsRecord);
            this.sucessfulPutCount.pushMetric(this.metricsRecord);
            this.sucessfulDeleteCount.pushMetric(this.metricsRecord);
            this.failedGetCount.pushMetric(this.metricsRecord);
            this.failedPutCount.pushMetric(this.metricsRecord);
            this.failedDeleteCount.pushMetric(this.metricsRecord);
        }
        this.metricsRecord.update();
    }

    public void resetAllMinMax() {
    }

    public float getRequests() {
        return this.requests.getPreviousIntervalValue();
    }

    public void incrementRequests(int inc) {
        this.requests.inc(inc);
    }

    public float getSucessfulGetCount() {
        return this.sucessfulGetCount.getPreviousIntervalValue();
    }

    public void incrementSucessfulGetRequests(int inc) {
        this.sucessfulGetCount.inc(inc);
    }

    public float getSucessfulPutCount() {
        return this.sucessfulPutCount.getPreviousIntervalValue();
    }

    public void incrementSucessfulPutRequests(int inc) {
        this.sucessfulPutCount.inc(inc);
    }

    public float getFailedPutCount() {
        return this.failedPutCount.getPreviousIntervalValue();
    }

    public void incrementFailedPutRequests(int inc) {
        this.failedPutCount.inc(inc);
    }

    public float getFailedGetCount() {
        return this.failedGetCount.getPreviousIntervalValue();
    }

    public void incrementFailedGetRequests(int inc) {
        this.failedGetCount.inc(inc);
    }

    public float getSucessfulDeleteCount() {
        return this.sucessfulDeleteCount.getPreviousIntervalValue();
    }

    public void incrementSucessfulDeleteRequests(int inc) {
        this.sucessfulDeleteCount.inc(inc);
    }

    public float getFailedDeleteCount() {
        return this.failedDeleteCount.getPreviousIntervalValue();
    }

    public void incrementFailedDeleteRequests(int inc) {
        this.failedDeleteCount.inc(inc);
    }
}

