/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift2;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.thrift.CallQueue;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift2.ThriftHBaseServiceHandler;
import org.apache.hadoop.hbase.thrift2.generated.THBaseService;
import org.apache.hadoop.hbase.util.InfoServer;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.AbstractNonblockingServer;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TNonblockingServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class ThriftServer {
    private static final Log log = LogFactory.getLog(ThriftServer.class);
    public static final String DEFAULT_LISTEN_PORT = "9090";

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Thrift", null, ThriftServer.getOptions(), "To start the Thrift server run 'bin/hbase-daemon.sh start thrift2'\nTo shutdown the thrift server run 'bin/hbase-daemon.sh stop thrift2' or send a kill signal to the thrift server pid", true);
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("b", "bind", true, "Address to bind the Thrift server to. Not supported by the Nonblocking and HsHa server [default: 0.0.0.0]");
        options.addOption("p", "port", true, "Port to bind to [default: 9090]");
        options.addOption("f", "framed", false, "Use framed transport");
        options.addOption("c", "compact", false, "Use the compact protocol");
        options.addOption("h", "help", false, "Print help information");
        options.addOption(null, "infoport", true, "Port for web UI");
        OptionGroup servers = new OptionGroup();
        servers.addOption(new Option("nonblocking", false, "Use the TNonblockingServer. This implies the framed transport."));
        servers.addOption(new Option("hsha", false, "Use the THsHaServer. This implies the framed transport."));
        servers.addOption(new Option("threadpool", false, "Use the TThreadPoolServer. This is the default."));
        options.addOptionGroup(servers);
        return options;
    }

    private static CommandLine parseArguments(Configuration conf, Options options, String[] args) throws ParseException, IOException {
        GenericOptionsParser genParser = new GenericOptionsParser(conf, args);
        String[] remainingArgs = genParser.getRemainingArgs();
        PosixParser parser = new PosixParser();
        return parser.parse(options, remainingArgs);
    }

    private static TProtocolFactory getTProtocolFactory(boolean isCompact) {
        if (isCompact) {
            log.debug((Object)"Using compact protocol");
            return new TCompactProtocol.Factory();
        }
        log.debug((Object)"Using binary protocol");
        return new TBinaryProtocol.Factory();
    }

    private static TTransportFactory getTTransportFactory(boolean framed) {
        if (framed) {
            log.debug((Object)"Using framed transport");
            return new TFramedTransport.Factory();
        }
        return new TTransportFactory();
    }

    private static InetSocketAddress bindToPort(String bindValue, int listenPort) throws UnknownHostException {
        try {
            if (bindValue == null) {
                return new InetSocketAddress(listenPort);
            }
            return new InetSocketAddress(InetAddress.getByName(bindValue), listenPort);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Could not bind to provided ip address", e);
        }
    }

    private static TServer getTNonBlockingServer(TProtocolFactory protocolFactory, THBaseService.Processor processor, TTransportFactory transportFactory, InetSocketAddress inetSocketAddress) throws TTransportException {
        TNonblockingServerSocket serverTransport = new TNonblockingServerSocket(inetSocketAddress);
        log.info((Object)("starting HBase Nonblocking Thrift server on " + inetSocketAddress.toString()));
        TNonblockingServer.Args serverArgs = new TNonblockingServer.Args((TNonblockingServerTransport)serverTransport);
        serverArgs.processor((TProcessor)processor);
        serverArgs.transportFactory(transportFactory);
        serverArgs.protocolFactory(protocolFactory);
        return new TNonblockingServer((AbstractNonblockingServer.AbstractNonblockingServerArgs)serverArgs);
    }

    private static TServer getTHsHaServer(TProtocolFactory protocolFactory, THBaseService.Processor processor, TTransportFactory transportFactory, InetSocketAddress inetSocketAddress, ThriftMetrics metrics) throws TTransportException {
        TNonblockingServerSocket serverTransport = new TNonblockingServerSocket(inetSocketAddress);
        log.info((Object)("starting HBase HsHA Thrift server on " + inetSocketAddress.toString()));
        THsHaServer.Args serverArgs = new THsHaServer.Args((TNonblockingServerTransport)serverTransport);
        ExecutorService executorService = ThriftServer.createExecutor(serverArgs.getWorkerThreads(), metrics);
        serverArgs.executorService(executorService);
        serverArgs.processor((TProcessor)processor);
        serverArgs.transportFactory(transportFactory);
        serverArgs.protocolFactory(protocolFactory);
        return new THsHaServer(serverArgs);
    }

    private static ExecutorService createExecutor(int workerThreads, ThriftMetrics metrics) {
        CallQueue callQueue = new CallQueue(new LinkedBlockingQueue<CallQueue.Call>(), metrics);
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        tfb.setDaemon(true);
        tfb.setNameFormat("thrift2-worker-%d");
        return new ThreadPoolExecutor(workerThreads, workerThreads, Long.MAX_VALUE, TimeUnit.SECONDS, (BlockingQueue<Runnable>)callQueue, tfb.build());
    }

    private static TServer getTThreadPoolServer(TProtocolFactory protocolFactory, THBaseService.Processor processor, TTransportFactory transportFactory, InetSocketAddress inetSocketAddress) throws TTransportException {
        TServerSocket serverTransport = new TServerSocket(inetSocketAddress);
        log.info((Object)("starting HBase ThreadPool Thrift server on " + inetSocketAddress.toString()));
        TThreadPoolServer.Args serverArgs = new TThreadPoolServer.Args((TServerTransport)serverTransport);
        serverArgs.processor((TProcessor)processor);
        serverArgs.transportFactory(transportFactory);
        serverArgs.protocolFactory(protocolFactory);
        return new TThreadPoolServer(serverArgs);
    }

    protected static void registerFilters(Configuration conf) {
        String[] filters = conf.getStrings("hbase.thrift.filters");
        if (filters != null) {
            for (String filterClass : filters) {
                String[] filterPart = filterClass.split(":");
                if (filterPart.length != 2) {
                    log.warn((Object)("Invalid filter specification " + filterClass + " - skipping"));
                    continue;
                }
                ParseFilter.registerFilter(filterPart[0], filterPart[1]);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        TServer server = null;
        Options options = ThriftServer.getOptions();
        try {
            Configuration conf = HBaseConfiguration.create();
            CommandLine cmd = ThriftServer.parseArguments(conf, options, args);
            List argList = cmd.getArgList();
            if (cmd.hasOption("help") || !argList.contains("start") || argList.contains("stop")) {
                ThriftServer.printUsage();
                System.exit(1);
            }
            int listenPort = 0;
            try {
                listenPort = Integer.parseInt(cmd.getOptionValue("port", DEFAULT_LISTEN_PORT));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Could not parse the value provided for the port option", e);
            }
            boolean nonblocking = cmd.hasOption("nonblocking");
            boolean hsha = cmd.hasOption("hsha");
            ThriftMetrics metrics = new ThriftMetrics(listenPort, conf, THBaseService.Iface.class);
            String implType = "threadpool";
            if (nonblocking) {
                implType = "nonblocking";
            } else if (hsha) {
                implType = "hsha";
            }
            conf.set("hbase.regionserver.thrift.server.type", implType);
            conf.setInt("hbase.regionserver.thrift.port", listenPort);
            ThriftServer.registerFilters(conf);
            boolean compact2 = cmd.hasOption("compact") || conf.getBoolean("hbase.regionserver.thrift.compact", false);
            TProtocolFactory protocolFactory = ThriftServer.getTProtocolFactory(compact2);
            THBaseService.Iface handler = ThriftHBaseServiceHandler.newInstance(conf, metrics);
            THBaseService.Processor<THBaseService.Iface> processor = new THBaseService.Processor<THBaseService.Iface>(handler);
            conf.setBoolean("hbase.regionserver.thrift.compact", compact2);
            boolean framed = cmd.hasOption("framed") || conf.getBoolean("hbase.regionserver.thrift.framed", false) || nonblocking || hsha;
            TTransportFactory transportFactory = ThriftServer.getTTransportFactory(framed);
            conf.setBoolean("hbase.regionserver.thrift.framed", framed);
            if (cmd.hasOption("bind") && (nonblocking || hsha)) {
                log.error((Object)"The Nonblocking and HsHaServer servers don't support IP address binding at the moment. See https://issues.apache.org/jira/browse/HBASE-2155 for details.");
                ThriftServer.printUsage();
                System.exit(1);
            }
            try {
                if (cmd.hasOption("infoport")) {
                    String val = cmd.getOptionValue("infoport");
                    conf.setInt("hbase.thrift.info.port", Integer.valueOf(val).intValue());
                    log.debug((Object)("Web UI port set to " + val));
                }
            }
            catch (NumberFormatException e) {
                log.error((Object)"Could not parse the value provided for the infoport option", (Throwable)e);
                ThriftServer.printUsage();
                System.exit(1);
            }
            int port = conf.getInt("hbase.thrift.info.port", 9095);
            if (port >= 0) {
                conf.setLong("startcode", System.currentTimeMillis());
                String a = conf.get("hbase.thrift.info.bindAddress", "0.0.0.0");
                InfoServer infoServer = new InfoServer("thrift", a, port, false, conf);
                infoServer.setAttribute("hbase.conf", conf);
                infoServer.start();
            }
            InetSocketAddress inetSocketAddress = ThriftServer.bindToPort(cmd.getOptionValue("bind"), listenPort);
            server = nonblocking ? ThriftServer.getTNonBlockingServer(protocolFactory, processor, transportFactory, inetSocketAddress) : (hsha ? ThriftServer.getTHsHaServer(protocolFactory, processor, transportFactory, inetSocketAddress, metrics) : ThriftServer.getTThreadPoolServer(protocolFactory, processor, transportFactory, inetSocketAddress));
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ThriftServer.printUsage();
            System.exit(1);
        }
        server.serve();
    }
}

