/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.EmptyWatcher;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.executor.RegionTransitionData;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.DeleteRequest;
import org.apache.zookeeper.proto.SetDataRequest;

public class ZKUtil {
    private static final Log LOG = LogFactory.getLog(ZKUtil.class);
    private static final char ZNODE_PATH_SEPARATOR = '/';
    private static int zkDumpConnectionTimeOut;

    public static RecoverableZooKeeper connect(Configuration conf, Watcher watcher) throws IOException {
        Properties properties = ZKConfig.makeZKProps(conf);
        String ensemble = ZKConfig.getZKQuorumServersString(properties);
        return ZKUtil.connect(conf, ensemble, watcher);
    }

    public static RecoverableZooKeeper connect(Configuration conf, String ensemble, Watcher watcher) throws IOException {
        return ZKUtil.connect(conf, ensemble, watcher, "");
    }

    public static RecoverableZooKeeper connect(Configuration conf, String ensemble, Watcher watcher, String descriptor) throws IOException {
        if (ensemble == null) {
            throw new IOException("Unable to determine ZooKeeper ensemble");
        }
        int timeout = conf.getInt("zookeeper.session.timeout", 180000);
        LOG.debug((Object)(descriptor + " opening connection to ZooKeeper with ensemble (" + ensemble + ")"));
        int retry = conf.getInt("zookeeper.recovery.retry", 3);
        int retryIntervalMillis = conf.getInt("zookeeper.recovery.retry.intervalmill", 1000);
        zkDumpConnectionTimeOut = conf.getInt("zookeeper.dump.connection.timeout", 1000);
        return new RecoverableZooKeeper(ensemble, timeout, watcher, retry, retryIntervalMillis);
    }

    public static void loginServer(Configuration conf, String keytabFileKey, String userNameKey, String hostname) throws IOException {
        ZKUtil.login(conf, keytabFileKey, userNameKey, hostname, "zookeeper.sasl.serverconfig", "zookeeper-server-keytab-kerberos");
    }

    public static void loginClient(Configuration conf, String keytabFileKey, String userNameKey, String hostname) throws IOException {
        ZKUtil.login(conf, keytabFileKey, userNameKey, hostname, "zookeeper.sasl.clientconfig", "zookeeper-client-keytab-kerberos");
    }

    private static void login(Configuration conf, String keytabFileKey, String userNameKey, String hostname, String loginContextProperty, String loginContextName) throws IOException {
        if (!ZKUtil.isSecureZooKeeper(conf)) {
            return;
        }
        if (System.getProperty("java.security.auth.login.config") != null) {
            return;
        }
        String keytabFilename = conf.get(keytabFileKey);
        if (keytabFilename == null) {
            LOG.warn((Object)("no keytab specified for: " + keytabFileKey));
            return;
        }
        String principalConfig = conf.get(userNameKey, System.getProperty("user.name"));
        String principalName = SecurityUtil.getServerPrincipal((String)principalConfig, (String)hostname);
        JaasConfiguration jaasConf = new JaasConfiguration(loginContextName, principalName, keytabFilename);
        javax.security.auth.login.Configuration.setConfiguration(jaasConf);
        System.setProperty(loginContextProperty, loginContextName);
    }

    public static String joinZNode(String prefix, String suffix) {
        return prefix + '/' + suffix;
    }

    public static String getParent(String node) {
        int idx = node.lastIndexOf(47);
        return idx <= 0 ? null : node.substring(0, idx);
    }

    public static String getNodeName(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public static String getZooKeeperClusterKey(Configuration conf) {
        return ZKUtil.getZooKeeperClusterKey(conf, null);
    }

    public static String getZooKeeperClusterKey(Configuration conf, String name) {
        String ensemble = conf.get("hbase.zookeeper.quorum".replaceAll("[\\t\\n\\x0B\\f\\r]", ""));
        StringBuilder builder = new StringBuilder(ensemble);
        builder.append(":");
        builder.append(conf.get("hbase.zookeeper.property.clientPort"));
        builder.append(":");
        builder.append(conf.get("zookeeper.znode.parent"));
        if (name != null && !name.isEmpty()) {
            builder.append(",");
            builder.append(name);
        }
        return builder.toString();
    }

    public static void applyClusterKeyToConf(Configuration conf, String key) throws IOException {
        String[] parts = ZKUtil.transformClusterKey(key);
        conf.set("hbase.zookeeper.quorum", parts[0]);
        conf.set("hbase.zookeeper.property.clientPort", parts[1]);
        conf.set("zookeeper.znode.parent", parts[2]);
    }

    public static String[] transformClusterKey(String key) throws IOException {
        String[] parts = key.split(":");
        if (parts.length != 3) {
            throw new IOException("Cluster key invalid, the format should be:hbase.zookeeper.quorum:hbase.zookeeper.client.port:zookeeper.znode.parent");
        }
        return parts;
    }

    public static boolean watchAndCheckExists(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            boolean exists2;
            Stat s = zkw.getRecoverableZooKeeper().exists(znode, zkw);
            boolean bl = exists2 = s != null;
            if (exists2) {
                LOG.debug((Object)zkw.prefix("Set watcher on existing znode " + znode));
            } else {
                LOG.debug((Object)zkw.prefix(znode + " does not exist. Watcher is set."));
            }
            return exists2;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return false;
        }
    }

    public static int checkExists(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            Stat s = zkw.getRecoverableZooKeeper().exists(znode, null);
            return s != null ? s.getVersion() : -1;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode (" + znode + ")"), (Throwable)e);
            zkw.keeperException(e);
            return -1;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to set watcher on znode (" + znode + ")"), (Throwable)e);
            zkw.interruptedException(e);
            return -1;
        }
    }

    public static List<String> listChildrenAndWatchForNewChildren(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            List<String> children = zkw.getRecoverableZooKeeper().getChildren(znode, zkw);
            return children;
        }
        catch (KeeperException.NoNodeException ke) {
            LOG.debug((Object)zkw.prefix("Unable to list children of znode " + znode + " " + "because node does not exist (not an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to list children of znode " + znode + " "), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to list children of znode " + znode + " "), (Throwable)e);
            zkw.interruptedException(e);
            return null;
        }
    }

    public static List<String> listChildrenAndWatchThem(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        List<String> children = ZKUtil.listChildrenAndWatchForNewChildren(zkw, znode);
        if (children == null) {
            return null;
        }
        for (String child : children) {
            ZKUtil.watchAndCheckExists(zkw, ZKUtil.joinZNode(znode, child));
        }
        return children;
    }

    public static List<String> listChildrenNoWatch(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        List<String> children = null;
        try {
            children = zkw.getRecoverableZooKeeper().getChildren(znode, null);
        }
        catch (KeeperException.NoNodeException nne) {
            return null;
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
        return children;
    }

    public static boolean nodeHasChildren(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            return !zkw.getRecoverableZooKeeper().getChildren(znode, null).isEmpty();
        }
        catch (KeeperException.NoNodeException ke) {
            LOG.debug((Object)zkw.prefix("Unable to list children of znode " + znode + " " + "because node does not exist (not an error)"));
            return false;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to list children of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to list children of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return false;
        }
    }

    public static int getNumberOfChildren(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            Stat stat = zkw.getRecoverableZooKeeper().exists(znode, null);
            return stat == null ? 0 : stat.getNumChildren();
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to get children of node " + znode));
            zkw.keeperException(e);
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
        }
        return 0;
    }

    public static byte[] getData(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        try {
            byte[] data = zkw.getRecoverableZooKeeper().getData(znode, null, null);
            ZKUtil.logRetrievedMsg(zkw, znode, data, false);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug((Object)zkw.prefix("Unable to get data of znode " + znode + " " + "because node does not exist (not an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return null;
        }
    }

    public static byte[] getDataAndWatch(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        return ZKUtil.getDataInternal(zkw, znode, null, true);
    }

    public static byte[] getDataAndWatch(ZooKeeperWatcher zkw, String znode, Stat stat) throws KeeperException {
        return ZKUtil.getDataInternal(zkw, znode, stat, true);
    }

    private static byte[] getDataInternal(ZooKeeperWatcher zkw, String znode, Stat stat, boolean watcherSet) throws KeeperException {
        try {
            byte[] data = zkw.getRecoverableZooKeeper().getData(znode, zkw, stat);
            ZKUtil.logRetrievedMsg(zkw, znode, data, watcherSet);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug((Object)zkw.prefix("Unable to get data of znode " + znode + " " + "because node does not exist (not an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return null;
        }
    }

    public static byte[] getDataNoWatch(ZooKeeperWatcher zkw, String znode, Stat stat) throws KeeperException {
        try {
            byte[] data = zkw.getRecoverableZooKeeper().getData(znode, null, stat);
            ZKUtil.logRetrievedMsg(zkw, znode, data, false);
            return data;
        }
        catch (KeeperException.NoNodeException e) {
            LOG.debug((Object)zkw.prefix("Unable to get data of znode " + znode + " " + "because node does not exist (not necessarily an error)"));
            return null;
        }
        catch (KeeperException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.keeperException(e);
            return null;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)zkw.prefix("Unable to get data of znode " + znode), (Throwable)e);
            zkw.interruptedException(e);
            return null;
        }
    }

    public static List<NodeAndData> getChildDataAndWatchForNewChildren(ZooKeeperWatcher zkw, String baseNode) throws KeeperException {
        List<String> nodes = ZKUtil.listChildrenAndWatchForNewChildren(zkw, baseNode);
        ArrayList<NodeAndData> newNodes = new ArrayList<NodeAndData>();
        if (nodes != null) {
            for (String node : nodes) {
                String nodePath = ZKUtil.joinZNode(baseNode, node);
                byte[] data = ZKUtil.getDataAndWatch(zkw, nodePath);
                newNodes.add(new NodeAndData(nodePath, data));
            }
        }
        return newNodes;
    }

    public static void updateExistingNodeData(ZooKeeperWatcher zkw, String znode, byte[] data, int expectedVersion) throws KeeperException {
        try {
            zkw.getRecoverableZooKeeper().setData(znode, data, expectedVersion);
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static boolean setData(ZooKeeperWatcher zkw, String znode, byte[] data, int expectedVersion) throws KeeperException, KeeperException.NoNodeException {
        try {
            return zkw.getRecoverableZooKeeper().setData(znode, data, expectedVersion) != null;
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return false;
        }
    }

    public static void createSetData(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        if (ZKUtil.checkExists(zkw, znode) == -1) {
            ZKUtil.createWithParents(zkw, znode, data);
        } else {
            ZKUtil.setData(zkw, znode, data);
        }
    }

    public static void setData(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException, KeeperException.NoNodeException {
        ZKUtil.setData(zkw, (ZKUtilOp.SetData)ZKUtilOp.setData(znode, data));
    }

    private static void setData(ZooKeeperWatcher zkw, ZKUtilOp.SetData setData) throws KeeperException, KeeperException.NoNodeException {
        SetDataRequest sd = (SetDataRequest)ZKUtil.toZooKeeperOp(zkw, setData).toRequestRecord();
        ZKUtil.setData(zkw, sd.getPath(), sd.getData(), sd.getVersion());
    }

    public static boolean isSecureZooKeeper(Configuration conf) {
        if (System.getProperty("java.security.auth.login.config") != null) {
            return true;
        }
        return "kerberos".equalsIgnoreCase(conf.get("hbase.security.authentication")) && conf.get("hbase.zookeeper.client.keytab.file") != null;
    }

    private static ArrayList<ACL> createACL(ZooKeeperWatcher zkw, String node) {
        if (ZKUtil.isSecureZooKeeper(zkw.getConfiguration())) {
            if (node.equals(zkw.baseZNode) || node.equals(zkw.rootServerZNode) || node.equals(zkw.masterAddressZNode) || node.equals(zkw.clusterIdZNode) || node.equals(zkw.rsZNode) || node.equals(zkw.backupMasterAddressesZNode) || node.startsWith(zkw.assignmentZNode) || node.startsWith(zkw.masterTableZNode) || node.startsWith(zkw.masterTableZNode92)) {
                return ZooKeeperWatcher.CREATOR_ALL_AND_WORLD_READABLE;
            }
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }
        return ZooDefs.Ids.OPEN_ACL_UNSAFE;
    }

    public static boolean createEphemeralNodeAndWatch(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        try {
            zkw.getRecoverableZooKeeper().create(znode, data, ZKUtil.createACL(zkw, znode), CreateMode.EPHEMERAL);
        }
        catch (KeeperException.NodeExistsException nee) {
            if (!ZKUtil.watchAndCheckExists(zkw, znode)) {
                return ZKUtil.createEphemeralNodeAndWatch(zkw, znode, data);
            }
            return false;
        }
        catch (InterruptedException e) {
            LOG.info((Object)"Interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return true;
    }

    public static boolean createNodeIfNotExistsAndWatch(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        try {
            zkw.getRecoverableZooKeeper().create(znode, data, ZKUtil.createACL(zkw, znode), CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nee) {
            try {
                zkw.getRecoverableZooKeeper().exists(znode, zkw);
            }
            catch (InterruptedException e) {
                zkw.interruptedException(e);
                return false;
            }
            return false;
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return false;
        }
        return true;
    }

    public static int createAndWatch(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException, KeeperException.NodeExistsException {
        try {
            zkw.getRecoverableZooKeeper().create(znode, data, ZKUtil.createACL(zkw, znode), CreateMode.PERSISTENT);
            return zkw.getRecoverableZooKeeper().exists(znode, zkw).getVersion();
        }
        catch (InterruptedException e) {
            zkw.interruptedException(e);
            return -1;
        }
    }

    public static void asyncCreate(ZooKeeperWatcher zkw, String znode, byte[] data, AsyncCallback.StringCallback cb, Object ctx) {
        zkw.getRecoverableZooKeeper().getZooKeeper().create(znode, data, ZKUtil.createACL(zkw, znode), CreateMode.PERSISTENT, cb, ctx);
    }

    public static void createAndFailSilent(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        ZKUtil.createAndFailSilent(zkw, znode, new byte[0]);
    }

    public static void createAndFailSilent(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        ZKUtil.createAndFailSilent(zkw, (ZKUtilOp.CreateAndFailSilent)ZKUtilOp.createAndFailSilent(znode, data));
    }

    private static void createAndFailSilent(ZooKeeperWatcher zkw, ZKUtilOp.CreateAndFailSilent cafs) throws KeeperException {
        CreateRequest create = (CreateRequest)ZKUtil.toZooKeeperOp(zkw, cafs).toRequestRecord();
        String znode = create.getPath();
        try {
            RecoverableZooKeeper zk = zkw.getRecoverableZooKeeper();
            if (zk.exists(znode, false) == null) {
                zk.create(znode, create.getData(), create.getAcl(), CreateMode.fromFlag((int)create.getFlags()));
            }
        }
        catch (KeeperException.NodeExistsException nee) {
        }
        catch (KeeperException.NoAuthException nee) {
            try {
                if (null == zkw.getRecoverableZooKeeper().exists(znode, false)) {
                    throw nee;
                }
            }
            catch (InterruptedException ie) {
                zkw.interruptedException(ie);
            }
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void createWithParents(ZooKeeperWatcher zkw, String znode) throws KeeperException {
        ZKUtil.createWithParents(zkw, znode, new byte[0]);
    }

    public static void createWithParents(ZooKeeperWatcher zkw, String znode, byte[] data) throws KeeperException {
        try {
            if (znode == null) {
                return;
            }
            zkw.getRecoverableZooKeeper().create(znode, data, ZKUtil.createACL(zkw, znode), CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nee) {
            return;
        }
        catch (KeeperException.NoNodeException nne) {
            ZKUtil.createWithParents(zkw, ZKUtil.getParent(znode));
            ZKUtil.createWithParents(zkw, znode, data);
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void deleteNode(ZooKeeperWatcher zkw, String node) throws KeeperException {
        ZKUtil.deleteNode(zkw, node, -1);
    }

    public static boolean deleteNode(ZooKeeperWatcher zkw, String node, int version) throws KeeperException {
        try {
            zkw.getRecoverableZooKeeper().delete(node, version);
            return true;
        }
        catch (KeeperException.BadVersionException bve) {
            return false;
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
            return false;
        }
    }

    public static void deleteNodeFailSilent(ZooKeeperWatcher zkw, String node) throws KeeperException {
        ZKUtil.deleteNodeFailSilent(zkw, (ZKUtilOp.DeleteNodeFailSilent)ZKUtilOp.deleteNodeFailSilent(node));
    }

    private static void deleteNodeFailSilent(ZooKeeperWatcher zkw, ZKUtilOp.DeleteNodeFailSilent dnfs) throws KeeperException {
        DeleteRequest delete = (DeleteRequest)ZKUtil.toZooKeeperOp(zkw, dnfs).toRequestRecord();
        try {
            zkw.getRecoverableZooKeeper().delete(delete.getPath(), delete.getVersion());
        }
        catch (KeeperException.NoNodeException nne) {
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void deleteNodeRecursively(ZooKeeperWatcher zkw, String node) throws KeeperException {
        try {
            List<String> children = ZKUtil.listChildrenNoWatch(zkw, node);
            if (children == null) {
                return;
            }
            if (!children.isEmpty()) {
                for (String child : children) {
                    ZKUtil.deleteNodeRecursively(zkw, ZKUtil.joinZNode(node, child));
                }
            }
            zkw.getRecoverableZooKeeper().delete(node, -1);
        }
        catch (InterruptedException ie) {
            zkw.interruptedException(ie);
        }
    }

    public static void deleteChildrenRecursively(ZooKeeperWatcher zkw, String node) throws KeeperException {
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, node);
        if (children == null || children.isEmpty()) {
            return;
        }
        for (String child : children) {
            ZKUtil.deleteNodeRecursively(zkw, ZKUtil.joinZNode(node, child));
        }
    }

    private static Op toZooKeeperOp(ZooKeeperWatcher zkw, ZKUtilOp op) throws UnsupportedOperationException {
        if (op == null) {
            return null;
        }
        if (op instanceof ZKUtilOp.CreateAndFailSilent) {
            ZKUtilOp.CreateAndFailSilent cafs = (ZKUtilOp.CreateAndFailSilent)op;
            return Op.create((String)cafs.getPath(), (byte[])cafs.getData(), ZKUtil.createACL(zkw, cafs.getPath()), (CreateMode)CreateMode.PERSISTENT);
        }
        if (op instanceof ZKUtilOp.DeleteNodeFailSilent) {
            ZKUtilOp.DeleteNodeFailSilent dnfs = (ZKUtilOp.DeleteNodeFailSilent)op;
            return Op.delete((String)dnfs.getPath(), (int)-1);
        }
        if (op instanceof ZKUtilOp.SetData) {
            ZKUtilOp.SetData sd = (ZKUtilOp.SetData)op;
            return Op.setData((String)sd.getPath(), (byte[])sd.getData(), (int)-1);
        }
        throw new UnsupportedOperationException("Unexpected ZKUtilOp type: " + op.getClass().getName());
    }

    public static void multiOrSequential(ZooKeeperWatcher zkw, List<ZKUtilOp> ops, boolean runSequentialOnMultiFailure) throws KeeperException {
        if (ops == null) {
            return;
        }
        boolean useMulti = zkw.getConfiguration().getBoolean("hbase.zookeeper.useMulti", true);
        if (useMulti) {
            LinkedList<Op> zkOps = new LinkedList<Op>();
            for (ZKUtilOp op : ops) {
                zkOps.add(ZKUtil.toZooKeeperOp(zkw, op));
            }
            try {
                zkw.getRecoverableZooKeeper().multi(zkOps);
            }
            catch (KeeperException ke) {
                switch (ke.code()) {
                    case NODEEXISTS: 
                    case NONODE: 
                    case BADVERSION: 
                    case NOAUTH: {
                        if (runSequentialOnMultiFailure) {
                            LOG.info((Object)("On call to ZK.multi, received exception: " + ke.toString() + "." + "  Attempting to run operations sequentially because" + " runSequentialOnMultiFailure is: " + runSequentialOnMultiFailure + "."));
                            ZKUtil.processSequentially(zkw, ops);
                            break;
                        }
                    }
                    default: {
                        throw ke;
                    }
                }
            }
            catch (InterruptedException ie) {
                zkw.interruptedException(ie);
            }
        } else {
            ZKUtil.processSequentially(zkw, ops);
        }
    }

    private static void processSequentially(ZooKeeperWatcher zkw, List<ZKUtilOp> ops) throws KeeperException, KeeperException.NoNodeException {
        for (ZKUtilOp op : ops) {
            if (op instanceof ZKUtilOp.CreateAndFailSilent) {
                ZKUtil.createAndFailSilent(zkw, (ZKUtilOp.CreateAndFailSilent)op);
                continue;
            }
            if (op instanceof ZKUtilOp.DeleteNodeFailSilent) {
                ZKUtil.deleteNodeFailSilent(zkw, (ZKUtilOp.DeleteNodeFailSilent)op);
                continue;
            }
            if (op instanceof ZKUtilOp.SetData) {
                ZKUtil.setData(zkw, (ZKUtilOp.SetData)op);
                continue;
            }
            throw new UnsupportedOperationException("Unexpected ZKUtilOp type: " + op.getClass().getName());
        }
    }

    public static String dump(ZooKeeperWatcher zkw) {
        StringBuilder sb = new StringBuilder();
        try {
            String[] servers;
            sb.append("HBase is rooted at ").append(zkw.baseZNode);
            sb.append("\nActive master address: ").append(ServerName.parseVersionedServerName(ZKUtil.getData(zkw, zkw.masterAddressZNode)));
            sb.append("\nBackup master addresses:");
            for (String child : ZKUtil.listChildrenNoWatch(zkw, zkw.backupMasterAddressesZNode)) {
                sb.append("\n ").append(child);
            }
            sb.append("\nRegion server holding ROOT: ").append(Bytes.toStringBinary(ZKUtil.getData(zkw, zkw.rootServerZNode)));
            sb.append("\nRegion servers:");
            for (String child : ZKUtil.listChildrenNoWatch(zkw, zkw.rsZNode)) {
                sb.append("\n ").append(child);
            }
            try {
                ZKUtil.getReplicationZnodesDump(zkw, sb);
            }
            catch (KeeperException ke) {
                LOG.warn((Object)("Couldn't get the replication znode dump." + ke.getStackTrace()));
            }
            sb.append("\nQuorum Server Statistics:");
            for (String server : servers = zkw.getQuorum().split(",")) {
                sb.append("\n ").append(server);
                try {
                    String[] stat = ZKUtil.getServerStats(server, zkDumpConnectionTimeOut);
                    if (stat == null) {
                        sb.append("[Error] invalid quorum server: " + server);
                        break;
                    }
                    for (String s : stat) {
                        sb.append("\n  ").append(s);
                    }
                }
                catch (Exception e) {
                    sb.append("\n  ERROR: ").append(e.getMessage());
                }
            }
        }
        catch (KeeperException ke) {
            sb.append("\nFATAL ZooKeeper Exception!\n");
            sb.append("\n" + ke.getMessage());
        }
        return sb.toString();
    }

    private static void getReplicationZnodesDump(ZooKeeperWatcher zkw, StringBuilder sb) throws KeeperException {
        String replicationZNodeName = zkw.getConfiguration().get("zookeeper.znode.replication", "replication");
        String replicationZnode = ZKUtil.joinZNode(zkw.baseZNode, replicationZNodeName);
        if (ZKUtil.checkExists(zkw, replicationZnode) == -1) {
            return;
        }
        LinkedList<String> stack = new LinkedList<String>();
        stack.add(replicationZnode);
        do {
            String znodeToProcess = (String)stack.remove(stack.size() - 1);
            sb.append("\n").append(znodeToProcess).append(": ").append(Bytes.toString(ZKUtil.getData(zkw, znodeToProcess)));
            for (String zNodeChild : ZKUtil.listChildrenNoWatch(zkw, znodeToProcess)) {
                stack.add(ZKUtil.joinZNode(znodeToProcess, zNodeChild));
            }
        } while (stack.size() > 0);
    }

    public static String[] getServerStats(String server, int timeout) throws IOException {
        String line;
        String[] sp = server.split(":");
        if (sp == null || sp.length == 0) {
            return null;
        }
        String host = sp[0];
        int port = sp.length > 1 ? Integer.parseInt(sp[1]) : 2181;
        Socket socket = new Socket();
        InetSocketAddress sockAddr = new InetSocketAddress(host, port);
        socket.connect(sockAddr, timeout);
        socket.setSoTimeout(timeout);
        PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        out.println("stat");
        out.flush();
        ArrayList<String> res = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            res.add(line);
        }
        socket.close();
        return res.toArray(new String[res.size()]);
    }

    private static void logRetrievedMsg(ZooKeeperWatcher zkw, String znode, byte[] data, boolean watcherSet) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)zkw.prefix("Retrieved " + (data == null ? 0 : data.length) + " byte(s) of data from znode " + znode + (watcherSet ? " and set watcher; " : "; data=") + (data == null ? "null" : (data.length == 0 ? "empty" : (znode.startsWith(zkw.assignmentZNode) ? RegionTransitionData.fromBytes(data).toString() : StringUtils.abbreviate((String)Bytes.toStringBinary(data), (int)32))))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForBaseZNode(Configuration conf) throws IOException {
        LOG.info((Object)"Waiting until the base znode is available");
        String parentZNode = conf.get("zookeeper.znode.parent", "/hbase");
        ZooKeeper zk = new ZooKeeper(ZKConfig.getZKQuorumServersString(conf), conf.getInt("zookeeper.session.timeout", 180000), (Watcher)EmptyWatcher.instance);
        int maxTimeMs = 10000;
        int maxNumAttempts = 50;
        KeeperException keeperEx = null;
        try {
            try {
                for (int attempt = 0; attempt < 50; ++attempt) {
                    block9: {
                        try {
                            if (zk.exists(parentZNode, false) == null) break block9;
                            LOG.info((Object)("Parent znode exists: " + parentZNode));
                            keeperEx = null;
                            break;
                        }
                        catch (KeeperException e) {
                            keeperEx = e;
                        }
                    }
                    Threads.sleepWithoutInterrupt(200L);
                }
            }
            finally {
                zk.close();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (keeperEx != null) {
            throw new IOException(keeperEx);
        }
    }

    public static void logZKTree(ZooKeeperWatcher zkw, String root) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)"Current zk system:");
        String prefix = "|-";
        LOG.debug((Object)(prefix + root));
        try {
            ZKUtil.logZKTree(zkw, root, prefix);
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void logZKTree(ZooKeeperWatcher zkw, String root, String prefix) throws KeeperException {
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, root);
        if (children == null) {
            return;
        }
        for (String child : children) {
            LOG.debug((Object)(prefix + child));
            String node = ZKUtil.joinZNode(root.equals("/") ? "" : root, child);
            ZKUtil.logZKTree(zkw, node, prefix + "---");
        }
    }

    public static abstract class ZKUtilOp {
        private String path;

        private ZKUtilOp(String path) {
            this.path = path;
        }

        public static ZKUtilOp createAndFailSilent(String path, byte[] data) {
            return new CreateAndFailSilent(path, data);
        }

        public static ZKUtilOp deleteNodeFailSilent(String path) {
            return new DeleteNodeFailSilent(path);
        }

        public static ZKUtilOp setData(String path, byte[] data) {
            return new SetData(path, data);
        }

        public String getPath() {
            return this.path;
        }

        public static class SetData
        extends ZKUtilOp {
            private byte[] data;

            private SetData(String path, byte[] data) {
                super(path);
                this.data = data;
            }

            public byte[] getData() {
                return this.data;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof SetData)) {
                    return false;
                }
                SetData op = (SetData)o;
                return this.getPath().equals(op.getPath()) && Arrays.equals(this.data, op.data);
            }
        }

        public static class DeleteNodeFailSilent
        extends ZKUtilOp {
            private DeleteNodeFailSilent(String path) {
                super(path);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof DeleteNodeFailSilent)) {
                    return false;
                }
                return super.equals(o);
            }
        }

        public static class CreateAndFailSilent
        extends ZKUtilOp {
            private byte[] data;

            private CreateAndFailSilent(String path, byte[] data) {
                super(path);
                this.data = data;
            }

            public byte[] getData() {
                return this.data;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof CreateAndFailSilent)) {
                    return false;
                }
                CreateAndFailSilent op = (CreateAndFailSilent)o;
                return this.getPath().equals(op.getPath()) && Arrays.equals(this.data, op.data);
            }
        }
    }

    public static class NodeAndData {
        private String node;
        private byte[] data;

        public NodeAndData(String node, byte[] data) {
            this.node = node;
            this.data = data;
        }

        public String getNode() {
            return this.node;
        }

        public byte[] getData() {
            return this.data;
        }

        public String toString() {
            return this.node + " (" + RegionTransitionData.fromBytes(this.data) + ")";
        }

        public boolean isEmpty() {
            return this.data.length == 0;
        }
    }

    private static class JaasConfiguration
    extends javax.security.auth.login.Configuration {
        private static final String SERVER_KEYTAB_KERBEROS_CONFIG_NAME = "zookeeper-server-keytab-kerberos";
        private static final String CLIENT_KEYTAB_KERBEROS_CONFIG_NAME = "zookeeper-client-keytab-kerberos";
        private static final Map<String, String> BASIC_JAAS_OPTIONS = new HashMap<String, String>();
        private static final Map<String, String> KEYTAB_KERBEROS_OPTIONS;
        private static final AppConfigurationEntry KEYTAB_KERBEROS_LOGIN;
        private static final AppConfigurationEntry[] KEYTAB_KERBEROS_CONF;
        private javax.security.auth.login.Configuration baseConfig;
        private final String loginContextName;
        private final boolean useTicketCache;
        private final String keytabFile;
        private final String principal;

        public JaasConfiguration(String loginContextName, String principal) {
            this(loginContextName, principal, null, true);
        }

        public JaasConfiguration(String loginContextName, String principal, String keytabFile) {
            this(loginContextName, principal, keytabFile, keytabFile == null || keytabFile.length() == 0);
        }

        private JaasConfiguration(String loginContextName, String principal, String keytabFile, boolean useTicketCache) {
            try {
                this.baseConfig = javax.security.auth.login.Configuration.getConfiguration();
            }
            catch (SecurityException e) {
                this.baseConfig = null;
            }
            this.loginContextName = loginContextName;
            this.useTicketCache = useTicketCache;
            this.keytabFile = keytabFile;
            this.principal = principal;
            LOG.info((Object)("JaasConfiguration loginContextName=" + loginContextName + " principal=" + principal + " useTicketCache=" + useTicketCache + " keytabFile=" + keytabFile));
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            if (this.loginContextName.equals(appName)) {
                if (!this.useTicketCache) {
                    KEYTAB_KERBEROS_OPTIONS.put("keyTab", this.keytabFile);
                    KEYTAB_KERBEROS_OPTIONS.put("useKeyTab", "true");
                }
                KEYTAB_KERBEROS_OPTIONS.put("principal", this.principal);
                KEYTAB_KERBEROS_OPTIONS.put("useTicketCache", this.useTicketCache ? "true" : "false");
                return KEYTAB_KERBEROS_CONF;
            }
            if (this.baseConfig != null) {
                return this.baseConfig.getAppConfigurationEntry(appName);
            }
            return null;
        }

        static {
            String jaasEnvVar = System.getenv("HBASE_JAAS_DEBUG");
            if (jaasEnvVar != null && "true".equalsIgnoreCase(jaasEnvVar)) {
                BASIC_JAAS_OPTIONS.put("debug", "true");
            }
            KEYTAB_KERBEROS_OPTIONS = new HashMap<String, String>();
            KEYTAB_KERBEROS_OPTIONS.put("doNotPrompt", "true");
            KEYTAB_KERBEROS_OPTIONS.put("storeKey", "true");
            KEYTAB_KERBEROS_OPTIONS.put("refreshKrb5Config", "true");
            KEYTAB_KERBEROS_OPTIONS.putAll(BASIC_JAAS_OPTIONS);
            KEYTAB_KERBEROS_LOGIN = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, KEYTAB_KERBEROS_OPTIONS);
            KEYTAB_KERBEROS_CONF = new AppConfigurationEntry[]{KEYTAB_KERBEROS_LOGIN};
        }
    }
}

