/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.jfreereport.castormodel.jfree.types;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ValignmentEnum
implements Serializable {
    public static final int TOP_TYPE = 0;
    public static final ValignmentEnum TOP = new ValignmentEnum(0, "top");
    public static final int MIDDLE_TYPE = 1;
    public static final ValignmentEnum MIDDLE = new ValignmentEnum(1, "middle");
    public static final int BOTTOM_TYPE = 2;
    public static final ValignmentEnum BOTTOM = new ValignmentEnum(2, "bottom");
    private static Hashtable _memberTable = ValignmentEnum.init();
    private int type = -1;
    private String stringValue = null;
    private Vector propertyChangeListeners;

    private ValignmentEnum(int type, String value) {
        this.type = type;
        this.stringValue = value;
        this.propertyChangeListeners = new Vector();
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.propertyChangeListeners.addElement(pcl);
    }

    public static Enumeration enumerate() {
        return _memberTable.elements();
    }

    public int getType() {
        return this.type;
    }

    protected void notifyPropertyChangeListeners(String fieldName, Object oldValue, Object newValue) {
        if (this.propertyChangeListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, fieldName, oldValue, newValue);
        for (int i = 0; i < this.propertyChangeListeners.size(); ++i) {
            ((PropertyChangeListener)this.propertyChangeListeners.elementAt(i)).propertyChange(event);
        }
    }

    public boolean removePropertyChangeListener(PropertyChangeListener pcl) {
        return this.propertyChangeListeners.removeElement(pcl);
    }

    private static Hashtable init() {
        Hashtable<String, ValignmentEnum> members = new Hashtable<String, ValignmentEnum>();
        members.put("top", TOP);
        members.put("middle", MIDDLE);
        members.put("bottom", BOTTOM);
        return members;
    }

    private Object readResolve() {
        return ValignmentEnum.valueOf(this.stringValue);
    }

    public String toString() {
        return this.stringValue;
    }

    public static ValignmentEnum valueOf(String string) {
        Object obj = null;
        if (string != null) {
            obj = _memberTable.get(string);
        }
        if (obj == null) {
            String err = "'" + string + "' is not a valid ValignmentEnum";
            throw new IllegalArgumentException(err);
        }
        return obj;
    }
}

