/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.jfreereport.castormodel.reportspec;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.pentaho.jfreereport.castormodel.reportspec.Series;
import org.pentaho.jfreereport.castormodel.reportspec.types.ChartType;
import org.pentaho.jfreereport.castormodel.reportspec.types.LegendLocation;
import org.xml.sax.ContentHandler;

public class Chart
implements Serializable {
    private ChartType _type = ChartType.valueOf("bar");
    private String _categoryColumn;
    private String _group;
    private String _resetGroup;
    private String _title = "Chart Title";
    private String _backgroundColor = "#FFFFFF";
    private boolean _isThreeDimensional = true;
    private boolean _has_isThreeDimensional;
    private boolean _isStacked = false;
    private boolean _has_isStacked;
    private boolean _isSummaryOnly = false;
    private boolean _has_isSummaryOnly;
    private boolean _showLegend = true;
    private boolean _has_showLegend;
    private boolean _drawLegendBorder = true;
    private boolean _has_drawLegendBorder;
    private LegendLocation _legendLocation = LegendLocation.valueOf("bottom");
    private int _labelRotation = 7;
    private boolean _has_labelRotation;
    private boolean _showBorder = false;
    private boolean _has_showBorder;
    private boolean _isHorizontal = false;
    private boolean _has_isHorizontal;
    private int _height = 400;
    private boolean _has_height;
    private int _width = 600;
    private boolean _has_width;
    private int _horizontalOffset = 0;
    private boolean _has_horizontalOffset;
    private List _seriesList;
    private List _valuesColumnList;

    public Chart() {
        this.setType(ChartType.valueOf("bar"));
        this.setTitle("Chart Title");
        this.setBackgroundColor("#FFFFFF");
        this.setLegendLocation(LegendLocation.valueOf("bottom"));
        this._seriesList = new ArrayList();
        this._valuesColumnList = new ArrayList();
    }

    public void addSeries(Series vSeries) throws IndexOutOfBoundsException {
        this._seriesList.add(vSeries);
    }

    public void addSeries(int index, Series vSeries) throws IndexOutOfBoundsException {
        this._seriesList.add(index, vSeries);
    }

    public void addValuesColumn(String vValuesColumn) throws IndexOutOfBoundsException {
        this._valuesColumnList.add(vValuesColumn);
    }

    public void addValuesColumn(int index, String vValuesColumn) throws IndexOutOfBoundsException {
        this._valuesColumnList.add(index, vValuesColumn);
    }

    public void deleteDrawLegendBorder() {
        this._has_drawLegendBorder = false;
    }

    public void deleteHeight() {
        this._has_height = false;
    }

    public void deleteHorizontalOffset() {
        this._has_horizontalOffset = false;
    }

    public void deleteIsHorizontal() {
        this._has_isHorizontal = false;
    }

    public void deleteIsStacked() {
        this._has_isStacked = false;
    }

    public void deleteIsSummaryOnly() {
        this._has_isSummaryOnly = false;
    }

    public void deleteIsThreeDimensional() {
        this._has_isThreeDimensional = false;
    }

    public void deleteLabelRotation() {
        this._has_labelRotation = false;
    }

    public void deleteShowBorder() {
        this._has_showBorder = false;
    }

    public void deleteShowLegend() {
        this._has_showLegend = false;
    }

    public void deleteWidth() {
        this._has_width = false;
    }

    public Enumeration enumerateSeries() {
        return Collections.enumeration(this._seriesList);
    }

    public Enumeration enumerateValuesColumn() {
        return Collections.enumeration(this._valuesColumnList);
    }

    public String getBackgroundColor() {
        return this._backgroundColor;
    }

    public String getCategoryColumn() {
        return this._categoryColumn;
    }

    public boolean getDrawLegendBorder() {
        return this._drawLegendBorder;
    }

    public String getGroup() {
        return this._group;
    }

    public int getHeight() {
        return this._height;
    }

    public int getHorizontalOffset() {
        return this._horizontalOffset;
    }

    public boolean getIsHorizontal() {
        return this._isHorizontal;
    }

    public boolean getIsStacked() {
        return this._isStacked;
    }

    public boolean getIsSummaryOnly() {
        return this._isSummaryOnly;
    }

    public boolean getIsThreeDimensional() {
        return this._isThreeDimensional;
    }

    public int getLabelRotation() {
        return this._labelRotation;
    }

    public LegendLocation getLegendLocation() {
        return this._legendLocation;
    }

    public String getResetGroup() {
        return this._resetGroup;
    }

    public Series getSeries(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._seriesList.size()) {
            throw new IndexOutOfBoundsException("getSeries: Index value '" + index + "' not in range [0.." + (this._seriesList.size() - 1) + "]");
        }
        return (Series)this._seriesList.get(index);
    }

    public Series[] getSeries() {
        int size = this._seriesList.size();
        Series[] array = new Series[size];
        for (int index = 0; index < size; ++index) {
            array[index] = (Series)this._seriesList.get(index);
        }
        return array;
    }

    public int getSeriesCount() {
        return this._seriesList.size();
    }

    public boolean getShowBorder() {
        return this._showBorder;
    }

    public boolean getShowLegend() {
        return this._showLegend;
    }

    public String getTitle() {
        return this._title;
    }

    public ChartType getType() {
        return this._type;
    }

    public String getValuesColumn(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._valuesColumnList.size()) {
            throw new IndexOutOfBoundsException("getValuesColumn: Index value '" + index + "' not in range [0.." + (this._valuesColumnList.size() - 1) + "]");
        }
        return (String)this._valuesColumnList.get(index);
    }

    public String[] getValuesColumn() {
        int size = this._valuesColumnList.size();
        String[] array = new String[size];
        for (int index = 0; index < size; ++index) {
            array[index] = (String)this._valuesColumnList.get(index);
        }
        return array;
    }

    public int getValuesColumnCount() {
        return this._valuesColumnList.size();
    }

    public int getWidth() {
        return this._width;
    }

    public boolean hasDrawLegendBorder() {
        return this._has_drawLegendBorder;
    }

    public boolean hasHeight() {
        return this._has_height;
    }

    public boolean hasHorizontalOffset() {
        return this._has_horizontalOffset;
    }

    public boolean hasIsHorizontal() {
        return this._has_isHorizontal;
    }

    public boolean hasIsStacked() {
        return this._has_isStacked;
    }

    public boolean hasIsSummaryOnly() {
        return this._has_isSummaryOnly;
    }

    public boolean hasIsThreeDimensional() {
        return this._has_isThreeDimensional;
    }

    public boolean hasLabelRotation() {
        return this._has_labelRotation;
    }

    public boolean hasShowBorder() {
        return this._has_showBorder;
    }

    public boolean hasShowLegend() {
        return this._has_showLegend;
    }

    public boolean hasWidth() {
        return this._has_width;
    }

    public boolean isDrawLegendBorder() {
        return this._drawLegendBorder;
    }

    public boolean isIsHorizontal() {
        return this._isHorizontal;
    }

    public boolean isIsStacked() {
        return this._isStacked;
    }

    public boolean isIsSummaryOnly() {
        return this._isSummaryOnly;
    }

    public boolean isIsThreeDimensional() {
        return this._isThreeDimensional;
    }

    public boolean isShowBorder() {
        return this._showBorder;
    }

    public boolean isShowLegend() {
        return this._showLegend;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator iterateSeries() {
        return this._seriesList.iterator();
    }

    public Iterator iterateValuesColumn() {
        return this._valuesColumnList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllSeries() {
        this._seriesList.clear();
    }

    public void removeAllValuesColumn() {
        this._valuesColumnList.clear();
    }

    public boolean removeSeries(Series vSeries) {
        boolean removed = this._seriesList.remove(vSeries);
        return removed;
    }

    public Series removeSeriesAt(int index) {
        Object obj = this._seriesList.remove(index);
        return (Series)obj;
    }

    public boolean removeValuesColumn(String vValuesColumn) {
        boolean removed = this._valuesColumnList.remove(vValuesColumn);
        return removed;
    }

    public String removeValuesColumnAt(int index) {
        Object obj = this._valuesColumnList.remove(index);
        return (String)obj;
    }

    public void setBackgroundColor(String backgroundColor) {
        this._backgroundColor = backgroundColor;
    }

    public void setCategoryColumn(String categoryColumn) {
        this._categoryColumn = categoryColumn;
    }

    public void setDrawLegendBorder(boolean drawLegendBorder) {
        this._drawLegendBorder = drawLegendBorder;
        this._has_drawLegendBorder = true;
    }

    public void setGroup(String group) {
        this._group = group;
    }

    public void setHeight(int height) {
        this._height = height;
        this._has_height = true;
    }

    public void setHorizontalOffset(int horizontalOffset) {
        this._horizontalOffset = horizontalOffset;
        this._has_horizontalOffset = true;
    }

    public void setIsHorizontal(boolean isHorizontal) {
        this._isHorizontal = isHorizontal;
        this._has_isHorizontal = true;
    }

    public void setIsStacked(boolean isStacked) {
        this._isStacked = isStacked;
        this._has_isStacked = true;
    }

    public void setIsSummaryOnly(boolean isSummaryOnly) {
        this._isSummaryOnly = isSummaryOnly;
        this._has_isSummaryOnly = true;
    }

    public void setIsThreeDimensional(boolean isThreeDimensional) {
        this._isThreeDimensional = isThreeDimensional;
        this._has_isThreeDimensional = true;
    }

    public void setLabelRotation(int labelRotation) {
        this._labelRotation = labelRotation;
        this._has_labelRotation = true;
    }

    public void setLegendLocation(LegendLocation legendLocation) {
        this._legendLocation = legendLocation;
    }

    public void setResetGroup(String resetGroup) {
        this._resetGroup = resetGroup;
    }

    public void setSeries(int index, Series vSeries) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._seriesList.size()) {
            throw new IndexOutOfBoundsException("setSeries: Index value '" + index + "' not in range [0.." + (this._seriesList.size() - 1) + "]");
        }
        this._seriesList.set(index, vSeries);
    }

    public void setSeries(Series[] vSeriesArray) {
        this._seriesList.clear();
        for (int i = 0; i < vSeriesArray.length; ++i) {
            this._seriesList.add(vSeriesArray[i]);
        }
    }

    public void setShowBorder(boolean showBorder) {
        this._showBorder = showBorder;
        this._has_showBorder = true;
    }

    public void setShowLegend(boolean showLegend) {
        this._showLegend = showLegend;
        this._has_showLegend = true;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public void setType(ChartType type) {
        this._type = type;
    }

    public void setValuesColumn(int index, String vValuesColumn) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._valuesColumnList.size()) {
            throw new IndexOutOfBoundsException("setValuesColumn: Index value '" + index + "' not in range [0.." + (this._valuesColumnList.size() - 1) + "]");
        }
        this._valuesColumnList.set(index, vValuesColumn);
    }

    public void setValuesColumn(String[] vValuesColumnArray) {
        this._valuesColumnList.clear();
        for (int i = 0; i < vValuesColumnArray.length; ++i) {
            this._valuesColumnList.add(vValuesColumnArray[i]);
        }
    }

    public void setWidth(int width) {
        this._width = width;
        this._has_width = true;
    }

    public static Chart unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Chart)Unmarshaller.unmarshal(Chart.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

