/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.jfreereport.functions;

import java.io.Serializable;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class ItemHideFunction
extends AbstractFunction
implements Serializable,
PageEventListener {
    private transient Object lastObject;
    private transient boolean visible;
    private transient boolean firstInGroup = true;
    private boolean ignoreGroupBreaks = false;
    private boolean ignorePageBreaks = false;
    private String element;
    private String field;

    public ItemHideFunction() {
    }

    public ItemHideFunction(String name) {
        this();
        this.setName(name);
    }

    public String getElement() {
        return this.element;
    }

    public void setElement(String name) {
        this.element = name;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void itemsAdvanced(ReportEvent event) {
        DataRow dataRow = event.getDataRow();
        Object fieldValue = dataRow.get(this.getField());
        if (this.firstInGroup) {
            this.visible = true;
            this.firstInGroup = false;
        } else {
            this.visible = !ObjectUtilities.equal((Object)this.lastObject, (Object)fieldValue);
        }
        this.lastObject = fieldValue;
        Element e = event.getReport().getItemBand().getElement(this.getElement());
        if (e != null) {
            e.setVisible(this.visible);
        }
    }

    public void itemsStarted(ReportEvent event) {
        if (!this.ignoreGroupBreaks) {
            this.lastObject = null;
            this.firstInGroup = true;
        }
    }

    public Object getValue() {
        if (this.visible) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void pageCanceled(ReportEvent event) {
    }

    public void pageFinished(ReportEvent event) {
    }

    public void pageStarted(ReportEvent event) {
        if (!this.ignorePageBreaks) {
            Object fieldValue = event.getDataRow().get(this.getField());
            this.visible = true;
            this.firstInGroup = true;
            this.lastObject = fieldValue;
            Element e = event.getReport().getItemBand().getElement(this.getElement());
            if (e != null) {
                e.setVisible(this.visible);
            }
        }
    }

    public Expression getInstance() {
        ItemHideFunction ih = (ItemHideFunction)super.getInstance();
        ih.lastObject = null;
        return ih;
    }

    public void reportStarted(ReportEvent event) {
        Object fieldValue = event.getDataRow().get(this.getField());
        this.visible = true;
        this.firstInGroup = true;
        this.lastObject = fieldValue;
        Element e = event.getReport().getItemBand().getElement(this.getElement());
        if (e != null) {
            e.setVisible(this.visible);
        }
    }

    public void pageRolledBack(ReportEvent event) {
    }

    public boolean isIgnoreGroupBreaks() {
        return this.ignoreGroupBreaks;
    }

    public void setIgnoreGroupBreaks(boolean ignoreGroupBreaks) {
        this.ignoreGroupBreaks = ignoreGroupBreaks;
    }

    public boolean isIgnorePageBreaks() {
        return this.ignorePageBreaks;
    }

    public void setIgnorePageBreaks(boolean ignorePageBreaks) {
        this.ignorePageBreaks = ignorePageBreaks;
    }
}

