/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.jfreereport.wizard.utility.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.pentaho.jfreereport.castormodel.reportspec.ReportSpec;
import org.pentaho.jfreereport.wizard.utility.CastorUtility;

public class ReportParameterUtility {
    public static String[] getParameterNamesFromReportSpecPath(String reportSpecPath) {
        try {
            ReportSpec reportSpec = null;
            boolean isZIPReportSpec = false;
            try {
                ZipFile zipFile = new ZipFile(reportSpecPath);
                ZipEntry reportSpecEntry = zipFile.getEntry("report.xreportspec");
                File tempFile = File.createTempFile("report", ".xreportspec", new File("/temp"));
                tempFile.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(tempFile);
                InputStream inputStream = zipFile.getInputStream(reportSpecEntry);
                int numRead = 0;
                byte[] bytes = new byte[16384];
                while ((numRead = inputStream.read(bytes)) != -1) {
                    if (numRead <= 0) continue;
                    fos.write(bytes, 0, numRead);
                }
                fos.close();
                reportSpec = (ReportSpec)CastorUtility.getInstance().readCastorObject(tempFile.getAbsolutePath(), ReportSpec.class);
                isZIPReportSpec = true;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!isZIPReportSpec && reportSpecPath != null) {
                reportSpec = (ReportSpec)CastorUtility.getInstance().readCastorObject(reportSpecPath, ReportSpec.class);
            }
            List paramsList = ReportParameterUtility.getParametersKeys(reportSpec.getQuery());
            return paramsList.toArray(new String[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List getParameterNamesFromQuery(String query) {
        LinkedList<String> params = new LinkedList<String>();
        while (query.indexOf("{") != -1) {
            String param = query.substring(query.indexOf("{") + 1, query.indexOf("}"));
            query = query.substring(query.indexOf("}") + 1);
            params.add(param);
        }
        return params;
    }

    public static String setupParameters(String query) {
        List parameterNames = ReportParameterUtility.getParameterNamesFromQuery(query);
        for (int i = 0; i < parameterNames.size(); ++i) {
            String param = (String)parameterNames.get(i);
            String paramValue = param.substring(param.indexOf("=") + 1);
            String trueParam = "\\{" + param + "\\}";
            query = query.replaceAll(trueParam, paramValue);
        }
        return query;
    }

    public static List getParametersKeys(String query) {
        List parameterNames = ReportParameterUtility.getParameterNamesFromQuery(query);
        LinkedList<String> parameterKeys = new LinkedList<String>();
        for (int i = 0; i < parameterNames.size(); ++i) {
            String param = (String)parameterNames.get(i);
            String paramKey = param.substring(0, param.indexOf("="));
            if (parameterKeys.contains(paramKey)) continue;
            parameterKeys.add(paramKey);
        }
        return parameterKeys;
    }

    public static String setupParametersForActionSequence(String query) {
        List parameterNames = ReportParameterUtility.getParameterNamesFromQuery(query);
        for (int i = 0; i < parameterNames.size(); ++i) {
            String param = (String)parameterNames.get(i);
            String paramKey = param.substring(0, param.indexOf("="));
            String trueParam = "\\{" + param + "\\}";
            query = query.replaceAll(trueParam, "{PREPARE:" + paramKey + "}");
        }
        return query;
    }
}

