/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.jfreereport.wizard.utility.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.pentaho.jfreereport.castormodel.reportspec.Chart;
import org.pentaho.jfreereport.castormodel.reportspec.Field;
import org.pentaho.jfreereport.castormodel.reportspec.ReportSpec;

public class ReportSpecUtility {
    public static final String NUMBER_FIELD = "number-field";
    public static final String DATE_FIELD = "date-field";
    public static final String STRING_FIELD = "string-field";
    public static final String MESSAGE_FIELD = "message-field";
    public static final String LABEL = "label";
    private static final int BOLD = 1;
    private static final int ITALIC = 2;
    private static final int BOLD_ITALIC = 3;
    private static HashMap templateGroupMap = new HashMap();

    public static void copyFile(String input, String output) {
        try {
            File inputFile = new File(input);
            File outputFile = new File(output);
            if (inputFile.exists() && !inputFile.getCanonicalPath().equals(outputFile.getCanonicalPath())) {
                FileInputStream fis = new FileInputStream(inputFile);
                FileOutputStream fos = new FileOutputStream(outputFile);
                fos.getChannel().transferFrom(fis.getChannel(), 0L, fis.getChannel().size());
                fos.close();
                fis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static Field[] getGroups(Field[] fields) {
        if (fields == null) {
            return null;
        }
        int numDetails = 0;
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (!f.getIsDetail()) continue;
            ++numDetails;
        }
        Field[] groups = new Field[fields.length - numDetails];
        int fieldCount = 0;
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (f.getIsDetail()) continue;
            groups[fieldCount] = f;
            ++fieldCount;
        }
        return groups;
    }

    public static String[] getFieldNames(ReportSpec spec) {
        String[] fieldNames = new String[spec.getField().length];
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = spec.getField(i).getName();
        }
        return fieldNames;
    }

    public static String[] getDetailFieldNames(ReportSpec spec) {
        Field[] details = ReportSpecUtility.getDetails(spec.getField());
        if (details == null) {
            return null;
        }
        String[] detailFieldNames = new String[details.length];
        for (int i = 0; i < details.length; ++i) {
            detailFieldNames[i] = details[i].getName();
        }
        return detailFieldNames;
    }

    public static String[] getGroupFieldNames(ReportSpec spec) {
        Field[] groups = ReportSpecUtility.getGroups(spec.getField());
        if (groups == null) {
            return null;
        }
        String[] groupFieldNames = new String[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            groupFieldNames[i] = groups[i].getName();
        }
        return groupFieldNames;
    }

    public static String[] getHorizontalAlignmentChoices() {
        String[] choices = new String[]{"left", "center", "right"};
        return choices;
    }

    public static String[] getVerticalAlignmentChoices() {
        String[] choices = new String[]{"top", "middle", "bottom"};
        return choices;
    }

    public static String[] getExpressionChoices(int type) {
        String[] choices = new String[]{"none", "sum", "average", "min", "max", "item-count", "group-count"};
        if (type == 12) {
            choices = new String[]{"none", "item-count", "group-count"};
        } else if (type == 91 || type == 92 || type == 93) {
            choices = new String[]{"none", "item-count", "group-count"};
        }
        return choices;
    }

    public static Field getField(Field[] fields, String name, boolean isDetail) {
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (!f.getName().equals(name) || f.getIsDetail() != isDetail) continue;
            return f;
        }
        return null;
    }

    public static String getFieldType(int fieldType) {
        if (fieldType == 2) {
            return NUMBER_FIELD;
        }
        if (fieldType == 91) {
            return DATE_FIELD;
        }
        return STRING_FIELD;
    }

    public static Field[] getDetails(Field[] fields) {
        if (fields == null) {
            return null;
        }
        int numDetails = 0;
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (!f.getIsDetail()) continue;
            ++numDetails;
        }
        Field[] details = new Field[numDetails];
        int fieldCount = 0;
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (!f.getIsDetail()) continue;
            details[fieldCount] = f;
            ++fieldCount;
        }
        return details;
    }

    public static boolean isLastGroup(ReportSpec reportSpec, Field f) {
        Field lastGroup = null;
        for (int i = 0; i < reportSpec.getFieldCount(); ++i) {
            if (reportSpec.getField(i).getIsDetail()) continue;
            lastGroup = reportSpec.getField(i);
        }
        return lastGroup != null && f.getName().equals(lastGroup.getName());
    }

    public static boolean isFontStyleBoldAndItalic(int fontStyle) {
        return (fontStyle & 3) == 3;
    }

    public static int addFontStyleItalic(int fontStyle) {
        return fontStyle & 2;
    }

    public static int addFontStyleBold(int fontStyle) {
        return fontStyle & 1;
    }

    public static boolean isFontStyleItalic(int fontStyle) {
        return (fontStyle & 2) == 2;
    }

    public static boolean isFontStyleBold(int fontStyle) {
        return (fontStyle & 1) == 1;
    }

    public static String getFontStyleString(int fontStyle) {
        if (ReportSpecUtility.isFontStyleBoldAndItalic(fontStyle)) {
            return "bold-italic";
        }
        if (ReportSpecUtility.isFontStyleItalic(fontStyle)) {
            return "italic";
        }
        if (ReportSpecUtility.isFontStyleBold(fontStyle)) {
            return "bold";
        }
        return "plain";
    }

    public static int getActualColumnCount(Field[] groups, Field[] details) {
        int count = 0;
        if (groups != null) {
            count += groups.length;
        }
        for (int i = 0; details != null && i < details.length; ++i) {
            if (details[i].getName() == null || details[i].getName().equals("")) continue;
            ++count;
        }
        return count;
    }

    public static String[] getSeriesColumns(Chart chart) {
        String[] series = new String[chart.getSeriesCount()];
        for (int i = 0; i < chart.getSeriesCount(); ++i) {
            series[i] = chart.getSeries(i).getSeriesName();
        }
        return series;
    }

    public static boolean doesExpressionExist(Field[] fields) {
        boolean expressionExists = false;
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            String value = f.getExpression();
            if (value == null || value.equals("none")) continue;
            expressionExists = true;
            break;
        }
        return expressionExists;
    }

    public static String[] enumerationToStringArray(Enumeration e) {
        LinkedList<String> list = new LinkedList<String>();
        while (e.hasMoreElements()) {
            String element = e.nextElement().toString();
            list.add(element);
        }
        return list.toArray(new String[0]);
    }

    public static int getItemFontSize(ReportSpec reportSpec, Field[] details) {
        int maxDetailFontSize = Integer.MIN_VALUE;
        for (int i = 0; i < details.length; ++i) {
            Field f = details[i];
            maxDetailFontSize = Math.max(maxDetailFontSize, f.getFontSize());
        }
        if (reportSpec.getColumnHeaderFontSize() > maxDetailFontSize) {
            maxDetailFontSize = reportSpec.getColumnHeaderFontSize();
        }
        return Math.max(reportSpec.getItemsFontSize(), maxDetailFontSize);
    }

    public static int getRowHeight(ReportSpec reportSpec, Field[] details) {
        return ReportSpecUtility.getItemFontSize(reportSpec, details) + 2;
    }

    public static String getJFreeExpressionClass(String expression) {
        String jfreeExpression = null;
        if (expression.equalsIgnoreCase("sum")) {
            jfreeExpression = "org.jfree.report.function.ItemSumFunction";
        } else if (expression.equalsIgnoreCase("average")) {
            jfreeExpression = "org.jfree.report.function.ItemAvgFunction";
        } else if (expression.equalsIgnoreCase("min")) {
            jfreeExpression = "org.jfree.report.function.ItemMinFunction";
        } else if (expression.equalsIgnoreCase("max")) {
            jfreeExpression = "org.jfree.report.function.ItemMaxFunction";
        } else if (expression.equalsIgnoreCase("item-count")) {
            jfreeExpression = "org.jfree.report.function.ItemCountFunction";
        } else if (expression.equalsIgnoreCase("group-count")) {
            jfreeExpression = "org.jfree.report.function.GroupCountFunction";
        }
        return jfreeExpression;
    }

    public static int getNumberOfGroupsInTemplate(String templatePath) {
        if (templatePath == null) {
            return 0;
        }
        SAXReader reader = new SAXReader();
        try {
            if (!templateGroupMap.containsKey(templatePath)) {
                Document templateDoc = reader.read(templatePath);
                templateGroupMap.put(templatePath, new Integer(ReportSpecUtility.getNumberOfGroupsInTemplate(templateDoc)));
            }
            return (Integer)templateGroupMap.get(templatePath);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int getNumberOfGroupsInTemplate(Document templateDoc) {
        int numGroups = 0;
        try {
            List groups = templateDoc.selectNodes("/report/groups/*");
            if (groups != null) {
                for (int i = 0; i < groups.size(); ++i) {
                    Element groupElement = (Element)groups.get(i);
                    List fields = groupElement.selectNodes("fields/*");
                    if (fields == null || fields.size() <= 0) continue;
                    ++numGroups;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return numGroups;
    }

    public static List<Element> getParserConfigElements(String reportPath) {
        LinkedList<Element> elements = new LinkedList<Element>();
        SAXReader reader = new SAXReader();
        try {
            File in = new File(reportPath);
            Document document = reader.read(in);
            List parserConfigProperties = document.selectNodes("/report/parser-config/*");
            for (int i = 0; i < parserConfigProperties.size(); ++i) {
                Element parserConfigProperty = (Element)parserConfigProperties.get(i);
                elements.add(parserConfigProperty);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return elements;
    }

    public static boolean doesHeaderExistForGroup(String templateFileName, int groupNumber) {
        try {
            File templateFile = new File(templateFileName);
            SAXReader reader = new SAXReader();
            Document templateDoc = reader.read(templateFile);
            List groups = templateDoc.selectNodes("/report/groups/*");
            Element groupElement = (Element)groups.get(groupNumber);
            Element groupHeader = (Element)groupElement.selectSingleNode("groupheader");
            if (groupHeader != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static List getParserConfigKeys(String reportPath, String type) {
        LinkedList<String> list = new LinkedList<String>();
        SAXReader reader = new SAXReader();
        try {
            File in = new File(reportPath);
            Document document = reader.read(in);
            List parserConfigProperties = document.selectNodes("/report/parser-config/*");
            for (int i = 0; i < parserConfigProperties.size(); ++i) {
                String commentString;
                Element parserConfigProperty = (Element)parserConfigProperties.get(i);
                Node commentNode = parserConfigProperty.selectSingleNode("comment()");
                if (commentNode == null || !(commentString = commentNode.getText().trim()).equalsIgnoreCase(type)) continue;
                list.add(parserConfigProperty.attributeValue("name"));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return list;
    }

    public static List getParserConfigValues(String reportPath, String type) {
        LinkedList<String> list = new LinkedList<String>();
        SAXReader reader = new SAXReader();
        try {
            File in = new File(reportPath);
            Document document = reader.read(in);
            List parserConfigProperties = document.selectNodes("/report/parser-config/*");
            for (int i = 0; i < parserConfigProperties.size(); ++i) {
                String commentString;
                Element parserConfigProperty = (Element)parserConfigProperties.get(i);
                Node commentNode = parserConfigProperty.selectSingleNode("comment()");
                if (commentNode == null || !(commentString = commentNode.getText().trim()).equalsIgnoreCase(type)) continue;
                list.add(parserConfigProperty.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return list;
    }
}

