/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerKillEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainerStartMonitoringEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorEventType;
import org.apache.hadoop.yarn.util.ResourceCalculatorPlugin;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;

public class ContainersMonitorImpl
extends AbstractService
implements ContainersMonitor {
    static final Log LOG = LogFactory.getLog(ContainersMonitorImpl.class);
    private long monitoringInterval;
    private MonitoringThread monitoringThread;
    final List<ContainerId> containersToBeRemoved;
    final Map<ContainerId, ProcessTreeInfo> containersToBeAdded;
    Map<ContainerId, ProcessTreeInfo> trackingContainers = new HashMap<ContainerId, ProcessTreeInfo>();
    final ContainerExecutor containerExecutor;
    private final Dispatcher eventDispatcher;
    private final Context context;
    private ResourceCalculatorPlugin resourceCalculatorPlugin;
    private Configuration conf;
    private Class<? extends ResourceCalculatorProcessTree> processTreeClass;
    private long maxVmemAllottedForContainers = -1L;
    private long maxPmemAllottedForContainers = -1L;
    private boolean pmemCheckEnabled;
    private boolean vmemCheckEnabled;
    private static final long UNKNOWN_MEMORY_LIMIT = -1L;

    public ContainersMonitorImpl(ContainerExecutor exec, AsyncDispatcher dispatcher, Context context) {
        super("containers-monitor");
        this.containerExecutor = exec;
        this.eventDispatcher = dispatcher;
        this.context = context;
        this.containersToBeAdded = new HashMap<ContainerId, ProcessTreeInfo>();
        this.containersToBeRemoved = new ArrayList<ContainerId>();
        this.monitoringThread = new MonitoringThread();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        long configuredPMemForContainers;
        this.monitoringInterval = conf.getLong("yarn.nodemanager.container-monitor.interval-ms", 3000L);
        Class clazz = conf.getClass("yarn.nodemanager.container-monitor.resource-calculator.class", null, ResourceCalculatorPlugin.class);
        this.resourceCalculatorPlugin = ResourceCalculatorPlugin.getResourceCalculatorPlugin((Class)clazz, (Configuration)conf);
        LOG.info((Object)(" Using ResourceCalculatorPlugin : " + this.resourceCalculatorPlugin));
        this.processTreeClass = conf.getClass("yarn.nodemanager.container-monitor.process-tree.class", null, ResourceCalculatorProcessTree.class);
        this.conf = conf;
        LOG.info((Object)(" Using ResourceCalculatorProcessTree : " + this.processTreeClass));
        this.maxPmemAllottedForContainers = configuredPMemForContainers = conf.getLong("yarn.nodemanager.resource.memory-mb", 8192L) * 1024L * 1024L;
        float vmemRatio = conf.getFloat("yarn.nodemanager.vmem-pmem-ratio", 2.1f);
        Preconditions.checkArgument((vmemRatio > 0.99f ? 1 : 0) != 0, (Object)"yarn.nodemanager.vmem-pmem-ratio should be at least 1.0");
        this.maxVmemAllottedForContainers = (long)(vmemRatio * (float)configuredPMemForContainers);
        this.pmemCheckEnabled = conf.getBoolean("yarn.nodemanager.pmem-check-enabled", true);
        this.vmemCheckEnabled = conf.getBoolean("yarn.nodemanager.vmem-check-enabled", false);
        LOG.info((Object)("Physical memory check enabled: " + this.pmemCheckEnabled));
        LOG.info((Object)("Virtual memory check enabled: " + this.vmemCheckEnabled));
        if (this.pmemCheckEnabled) {
            long totalPhysicalMemoryOnNM = -1L;
            if (this.resourceCalculatorPlugin != null && (totalPhysicalMemoryOnNM = this.resourceCalculatorPlugin.getPhysicalMemorySize()) <= 0L) {
                LOG.warn((Object)"NodeManager's totalPmem could not be calculated. Setting it to -1");
                totalPhysicalMemoryOnNM = -1L;
            }
            if (totalPhysicalMemoryOnNM != -1L && (float)this.maxPmemAllottedForContainers > (float)totalPhysicalMemoryOnNM * 0.8f) {
                LOG.warn((Object)("NodeManager configured with " + StringUtils.TraditionalBinaryPrefix.long2String((long)this.maxPmemAllottedForContainers, (String)"", (int)1) + " physical memory allocated to containers, which is more than " + "80% of the total physical memory available (" + StringUtils.TraditionalBinaryPrefix.long2String((long)totalPhysicalMemoryOnNM, (String)"", (int)1) + "). Thrashing might happen."));
            }
        }
        super.serviceInit(conf);
    }

    private boolean isEnabled() {
        if (this.resourceCalculatorPlugin == null) {
            LOG.info((Object)("ResourceCalculatorPlugin is unavailable on this system. " + this.getClass().getName() + " is disabled."));
            return false;
        }
        if (ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)"0", this.processTreeClass, (Configuration)this.conf) == null) {
            LOG.info((Object)("ResourceCalculatorProcessTree is unavailable on this system. " + this.getClass().getName() + " is disabled."));
            return false;
        }
        if (!this.isPmemCheckEnabled() && !this.isVmemCheckEnabled()) {
            LOG.info((Object)"Neither virutal-memory nor physical-memory monitoring is needed. Not running the monitor-thread");
            return false;
        }
        return true;
    }

    protected void serviceStart() throws Exception {
        if (this.isEnabled()) {
            this.monitoringThread.start();
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.isEnabled()) {
            this.monitoringThread.interrupt();
            try {
                this.monitoringThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        super.serviceStop();
    }

    boolean isProcessTreeOverLimit(String containerId, long currentMemUsage, long curMemUsageOfAgedProcesses, long vmemLimit) {
        boolean isOverLimit = false;
        if (currentMemUsage > 2L * vmemLimit) {
            LOG.warn((Object)("Process tree for container: " + containerId + " running over twice " + "the configured limit. Limit=" + vmemLimit + ", current usage = " + currentMemUsage));
            isOverLimit = true;
        } else if (curMemUsageOfAgedProcesses > vmemLimit) {
            LOG.warn((Object)("Process tree for container: " + containerId + " has processes older than 1 " + "iteration running over the configured limit. Limit=" + vmemLimit + ", current usage = " + curMemUsageOfAgedProcesses));
            isOverLimit = true;
        }
        return isOverLimit;
    }

    boolean isProcessTreeOverLimit(ResourceCalculatorProcessTree pTree, String containerId, long limit) {
        long currentMemUsage = pTree.getCumulativeVmem();
        long curMemUsageOfAgedProcesses = pTree.getCumulativeVmem(1);
        return this.isProcessTreeOverLimit(containerId, currentMemUsage, curMemUsageOfAgedProcesses, limit);
    }

    @Override
    public long getVmemAllocatedForContainers() {
        return this.maxVmemAllottedForContainers;
    }

    @Override
    public boolean isPmemCheckEnabled() {
        return this.pmemCheckEnabled;
    }

    @Override
    public long getPmemAllocatedForContainers() {
        return this.maxPmemAllottedForContainers;
    }

    @Override
    public boolean isVmemCheckEnabled() {
        return this.vmemCheckEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ContainersMonitorEvent monitoringEvent) {
        if (!this.isEnabled()) {
            return;
        }
        ContainerId containerId = monitoringEvent.getContainerId();
        switch ((ContainersMonitorEventType)monitoringEvent.getType()) {
            case START_MONITORING_CONTAINER: {
                ContainerStartMonitoringEvent startEvent = (ContainerStartMonitoringEvent)monitoringEvent;
                Map<ContainerId, ProcessTreeInfo> map = this.containersToBeAdded;
                synchronized (map) {
                    ProcessTreeInfo processTreeInfo = new ProcessTreeInfo(containerId, null, null, startEvent.getVmemLimit(), startEvent.getPmemLimit());
                    this.containersToBeAdded.put(containerId, processTreeInfo);
                    break;
                }
            }
            case STOP_MONITORING_CONTAINER: {
                List<ContainerId> list = this.containersToBeRemoved;
                synchronized (list) {
                    this.containersToBeRemoved.add(containerId);
                    break;
                }
            }
        }
    }

    private class MonitoringThread
    extends Thread {
        public MonitoringThread() {
            super("Container Monitor");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                List<ContainerId> tmp;
                if (LOG.isDebugEnabled()) {
                    tmp = new StringBuilder("[ ");
                    for (ProcessTreeInfo processTreeInfo : ContainersMonitorImpl.this.trackingContainers.values()) {
                        ((StringBuilder)((Object)tmp)).append(processTreeInfo.getPID());
                        ((StringBuilder)((Object)tmp)).append(" ");
                    }
                    LOG.debug((Object)("Current ProcessTree list : " + ((StringBuilder)((Object)tmp)).substring(0, ((StringBuilder)((Object)tmp)).length()) + "]"));
                }
                tmp = ContainersMonitorImpl.this.containersToBeAdded;
                synchronized (tmp) {
                    for (Map.Entry entry : ContainersMonitorImpl.this.containersToBeAdded.entrySet()) {
                        ContainerId containerId = (ContainerId)entry.getKey();
                        ProcessTreeInfo processTreeInfo = (ProcessTreeInfo)entry.getValue();
                        LOG.info((Object)("Starting resource-monitoring for " + containerId));
                        ContainersMonitorImpl.this.trackingContainers.put(containerId, processTreeInfo);
                    }
                    ContainersMonitorImpl.this.containersToBeAdded.clear();
                }
                tmp = ContainersMonitorImpl.this.containersToBeRemoved;
                synchronized (tmp) {
                    for (ContainerId containerId : ContainersMonitorImpl.this.containersToBeRemoved) {
                        ContainersMonitorImpl.this.trackingContainers.remove(containerId);
                        LOG.info((Object)("Stopping resource-monitoring for " + containerId));
                    }
                    ContainersMonitorImpl.this.containersToBeRemoved.clear();
                }
                long vmemStillInUsage = 0L;
                long l = 0L;
                Iterator<Map.Entry<ContainerId, ProcessTreeInfo>> it = ContainersMonitorImpl.this.trackingContainers.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<ContainerId, ProcessTreeInfo> entry = it.next();
                    ContainerId containerId = entry.getKey();
                    ProcessTreeInfo ptInfo = entry.getValue();
                    try {
                        String pId = ptInfo.getPID();
                        if (pId == null && (pId = ContainersMonitorImpl.this.containerExecutor.getProcessId(ptInfo.getContainerId())) != null) {
                            LOG.debug((Object)("Tracking ProcessTree " + pId + " for the first time"));
                            ResourceCalculatorProcessTree pt = ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)pId, (Class)ContainersMonitorImpl.this.processTreeClass, (Configuration)ContainersMonitorImpl.this.conf);
                            ptInfo.setPid(pId);
                            ptInfo.setProcessTree(pt);
                        }
                        if (pId == null) continue;
                        LOG.debug((Object)("Constructing ProcessTree for : PID = " + pId + " ContainerId = " + containerId));
                        ResourceCalculatorProcessTree pTree = ptInfo.getProcessTree();
                        pTree.updateProcessTree();
                        long currentVmemUsage = pTree.getCumulativeVmem();
                        long currentPmemUsage = pTree.getCumulativeRssmem();
                        long curMemUsageOfAgedProcesses = pTree.getCumulativeVmem(1);
                        long curRssMemUsageOfAgedProcesses = pTree.getCumulativeRssmem(1);
                        long vmemLimit = ptInfo.getVmemLimit();
                        long pmemLimit = ptInfo.getPmemLimit();
                        LOG.info((Object)(String.format("Memory usage of ProcessTree %s for container-id %s: ", pId, containerId.toString()) + this.formatUsageString(currentVmemUsage, vmemLimit, currentPmemUsage, pmemLimit)));
                        boolean isMemoryOverLimit = false;
                        String msg = "";
                        if (ContainersMonitorImpl.this.isVmemCheckEnabled() && ContainersMonitorImpl.this.isProcessTreeOverLimit(containerId.toString(), currentVmemUsage, curMemUsageOfAgedProcesses, vmemLimit)) {
                            msg = this.formatErrorMessage("virtual", currentVmemUsage, vmemLimit, currentPmemUsage, pmemLimit, pId, containerId, pTree);
                            isMemoryOverLimit = true;
                        } else if (ContainersMonitorImpl.this.isPmemCheckEnabled() && ContainersMonitorImpl.this.isProcessTreeOverLimit(containerId.toString(), currentPmemUsage, curRssMemUsageOfAgedProcesses, pmemLimit)) {
                            msg = this.formatErrorMessage("physical", currentVmemUsage, vmemLimit, currentPmemUsage, pmemLimit, pId, containerId, pTree);
                            isMemoryOverLimit = true;
                        }
                        if (isMemoryOverLimit) {
                            LOG.warn((Object)msg);
                            if (!pTree.checkPidPgrpidForMatch()) {
                                LOG.error((Object)("Killed container process with PID " + pId + " but it is not a process group leader."));
                            }
                            ContainersMonitorImpl.this.eventDispatcher.getEventHandler().handle((Event)new ContainerKillEvent(containerId, msg));
                            it.remove();
                            LOG.info((Object)("Removed ProcessTree with root " + pId));
                            continue;
                        }
                        vmemStillInUsage += currentVmemUsage;
                        l += currentPmemUsage;
                    }
                    catch (Exception e) {
                        LOG.warn((Object)("Uncaught exception in ContainerMemoryManager while managing memory of " + containerId), (Throwable)e);
                    }
                }
                try {
                    Thread.sleep(ContainersMonitorImpl.this.monitoringInterval);
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)(ContainersMonitorImpl.class.getName() + " is interrupted. Exiting."));
                    return;
                }
            }
        }

        private String formatErrorMessage(String memTypeExceeded, long currentVmemUsage, long vmemLimit, long currentPmemUsage, long pmemLimit, String pId, ContainerId containerId, ResourceCalculatorProcessTree pTree) {
            return String.format("Container [pid=%s,containerID=%s] is running beyond %s memory limits. ", pId, containerId, memTypeExceeded) + "Current usage: " + this.formatUsageString(currentVmemUsage, vmemLimit, currentPmemUsage, pmemLimit) + ". Killing container.\n" + "Dump of the process-tree for " + containerId + " :\n" + pTree.getProcessTreeDump();
        }

        private String formatUsageString(long currentVmemUsage, long vmemLimit, long currentPmemUsage, long pmemLimit) {
            return String.format("%sB of %sB physical memory used; %sB of %sB virtual memory used", StringUtils.TraditionalBinaryPrefix.long2String((long)currentPmemUsage, (String)"", (int)1), StringUtils.TraditionalBinaryPrefix.long2String((long)pmemLimit, (String)"", (int)1), StringUtils.TraditionalBinaryPrefix.long2String((long)currentVmemUsage, (String)"", (int)1), StringUtils.TraditionalBinaryPrefix.long2String((long)vmemLimit, (String)"", (int)1));
        }
    }

    private static class ProcessTreeInfo {
        private ContainerId containerId;
        private String pid;
        private ResourceCalculatorProcessTree pTree;
        private long vmemLimit;
        private long pmemLimit;

        public ProcessTreeInfo(ContainerId containerId, String pid, ResourceCalculatorProcessTree pTree, long vmemLimit, long pmemLimit) {
            this.containerId = containerId;
            this.pid = pid;
            this.pTree = pTree;
            this.vmemLimit = vmemLimit;
            this.pmemLimit = pmemLimit;
        }

        public ContainerId getContainerId() {
            return this.containerId;
        }

        public String getPID() {
            return this.pid;
        }

        public void setPid(String pid) {
            this.pid = pid;
        }

        public ResourceCalculatorProcessTree getProcessTree() {
            return this.pTree;
        }

        public void setProcessTree(ResourceCalculatorProcessTree pTree) {
            this.pTree = pTree;
        }

        public long getVmemLimit() {
            return this.vmemLimit;
        }

        public long getPmemLimit() {
            return this.pmemLimit;
        }
    }
}

