/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hbase.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.mapred.TableInputFormat;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;
import org.pentaho.di.core.Const;
import org.pentaho.hbase.mapred.PentahoTableRecordReader;

public class PentahoTableInputFormat
extends TableInputFormat {
    public static final String INPUT_TABLE = "hbase.mapred.inputtable";
    public static final String SCAN_CACHEDROWS = "hbase.mapreduce.scan.cachedrows";
    public static final String SCAN_TIMESTAMP = "hbase.mapreduce.scan.timestamp";
    public static final String SCAN_TIMERANGE_START = "hbase.mapreduce.scan.timerange.start";
    public static final String SCAN_TIMERANGE_END = "hbase.mapreduce.scan.timerange.end";
    protected final Log PLOG = LogFactory.getLog(PentahoTableInputFormat.class);

    public void configure(JobConf job) {
        String tableName = job.get(INPUT_TABLE);
        String colArg = job.get("hbase.mapred.tablecolumns");
        if (!Const.isEmpty((String)colArg)) {
            String[] colNames = colArg.split(" ");
            byte[][] m_cols = new byte[colNames.length][];
            for (int i = 0; i < m_cols.length; ++i) {
                String colN = colNames[i];
                m_cols[i] = Bytes.toBytes((String)colN);
            }
            this.setInputColumns(m_cols);
        }
        try {
            this.setHTable(new HTable(HBaseConfiguration.create((Configuration)job), tableName));
        }
        catch (Exception e) {
            this.PLOG.error((Object)StringUtils.stringifyException((Throwable)e));
        }
        PentahoTableRecordReader rr = new PentahoTableRecordReader();
        String cacheSize = job.get(SCAN_CACHEDROWS);
        if (!Const.isEmpty((String)cacheSize)) {
            rr.setScanCacheRowSize(Integer.parseInt(cacheSize));
        }
        this.setTableRecordReader(rr);
    }

    public void validateInput(JobConf job) throws IOException {
        String tableName = job.get(INPUT_TABLE);
        if (Const.isEmpty((String)tableName)) {
            throw new IOException("expecting one table name");
        }
        if (this.getHTable() == null) {
            throw new IOException("could not connect to table '" + tableName + "'");
        }
        String colArg = job.get("hbase.mapred.tablecolumns");
        if (colArg == null || colArg.length() == 0) {
            throw new IOException("expecting at least one column/column family");
        }
    }
}

