/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.partition.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.PartitionDatabaseMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class PartitionSchemaDialog
extends Dialog {
    private static Class<?> PKG = PartitionSchemaDialog.class;
    private PartitionSchema partitionSchema;
    private Shell shell;
    private Text wName;
    private Button wDynamic;
    private TextVar wNumber;
    private TableView wPartitions;
    private Button wOK;
    private Button wGet;
    private Button wCancel;
    private ModifyListener lsMod;
    private PropsUI props;
    private int middle;
    private int margin;
    private PartitionSchema originalSchema;
    private boolean ok;
    private List<DatabaseMeta> databases;
    private VariableSpace variableSpace;

    public PartitionSchemaDialog(Shell par, PartitionSchema partitionSchema, List<DatabaseMeta> databases, VariableSpace variableSpace) {
        super(par, 0);
        this.partitionSchema = (PartitionSchema)partitionSchema.clone();
        this.originalSchema = partitionSchema;
        this.databases = databases;
        this.variableSpace = variableSpace;
        this.props = PropsUI.getInstance();
        this.ok = false;
    }

    public boolean open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageFolderConnections());
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PartitionSchemaDialog.this.partitionSchema.setChanged();
            }
        };
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setText(BaseMessages.getString(PKG, (String)"PartitionSchemaDialog.Shell.Title", (String[])new String[0]));
        this.shell.setLayout((Layout)formLayout);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(" &OK ");
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"PartitionSchema.ImportPartitions", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(" &Cancel ");
        Button[] buttons = new Button[]{this.wOK, this.wGet, this.wCancel};
        BaseStepDialog.positionBottomButtons((Composite)this.shell, buttons, this.margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"PartitionSchemaDialog.PartitionName.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, 0);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(this.middle, 0);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(this.lsMod);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment(0, 0);
        fdName.left = new FormAttachment(this.middle, this.margin);
        fdName.right = new FormAttachment(95, 0);
        this.wName.setLayoutData((Object)fdName);
        Label wlDynamic = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlDynamic);
        wlDynamic.setText(BaseMessages.getString(PKG, (String)"PartitionSchemaDialog.Dynamic.Label", (String[])new String[0]));
        FormData fdlDynamic = new FormData();
        fdlDynamic.top = new FormAttachment((Control)this.wName, this.margin);
        fdlDynamic.left = new FormAttachment(0, 0);
        fdlDynamic.right = new FormAttachment(this.middle, 0);
        wlDynamic.setLayoutData((Object)fdlDynamic);
        this.wDynamic = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wDynamic);
        this.wDynamic.setToolTipText(BaseMessages.getString(PKG, (String)"PartitionSchemaDialog.Dynamic.Tooltip", (String[])new String[0]));
        FormData fdDynamic = new FormData();
        fdDynamic.top = new FormAttachment((Control)this.wName, this.margin);
        fdDynamic.left = new FormAttachment(this.middle, this.margin);
        fdDynamic.right = new FormAttachment(95, 0);
        this.wDynamic.setLayoutData((Object)fdDynamic);
        Label wlNumber = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlNumber);
        wlNumber.setText(BaseMessages.getString(PKG, (String)"PartitionSchemaDialog.Number.Label", (String[])new String[0]));
        FormData fdlNumber = new FormData();
        fdlNumber.top = new FormAttachment((Control)this.wDynamic, this.margin);
        fdlNumber.left = new FormAttachment(0, 0);
        fdlNumber.right = new FormAttachment(this.middle, 0);
        wlNumber.setLayoutData((Object)fdlNumber);
        this.wNumber = new TextVar(this.variableSpace, (Composite)this.shell, 18436, BaseMessages.getString(PKG, (String)"PartitionSchemaDialog.Number.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNumber);
        FormData fdNumber = new FormData();
        fdNumber.top = new FormAttachment((Control)this.wDynamic, this.margin);
        fdNumber.left = new FormAttachment(this.middle, this.margin);
        fdNumber.right = new FormAttachment(95, 0);
        this.wNumber.setLayoutData(fdNumber);
        Label wlPartitions = new Label((Composite)this.shell, 131072);
        wlPartitions.setText(BaseMessages.getString(PKG, (String)"PartitionSchemaDialog.Partitions.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPartitions);
        FormData fdlPartitions = new FormData();
        fdlPartitions.left = new FormAttachment(0, 0);
        fdlPartitions.right = new FormAttachment(this.middle, 0);
        fdlPartitions.top = new FormAttachment((Control)this.wNumber, this.margin);
        wlPartitions.setLayoutData((Object)fdlPartitions);
        ColumnInfo[] partitionColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PartitionSchemaDialog.PartitionID.Label", (String[])new String[0]), 1, false, false)};
        this.wPartitions = new TableView(Variables.getADefaultVariableSpace(), (Composite)this.shell, 67586, partitionColumns, 1, this.lsMod, this.props);
        this.props.setLook((Control)this.wPartitions);
        FormData fdPartitions = new FormData();
        fdPartitions.left = new FormAttachment(this.middle, this.margin);
        fdPartitions.right = new FormAttachment(100, 0);
        fdPartitions.top = new FormAttachment((Control)this.wNumber, this.margin);
        fdPartitions.bottom = new FormAttachment((Control)this.wOK, -this.margin * 2);
        this.wPartitions.setLayoutData(fdPartitions);
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PartitionSchemaDialog.this.ok();
            }
        });
        this.wGet.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PartitionSchemaDialog.this.importPartitions();
            }
        });
        this.wCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PartitionSchemaDialog.this.cancel();
            }
        });
        SelectionAdapter selAdapter = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PartitionSchemaDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)selAdapter);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                PartitionSchemaDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.ok;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wName.setText(Const.NVL((String)this.partitionSchema.getName(), (String)""));
        this.refreshPartitions();
        this.wDynamic.setSelection(this.partitionSchema.isDynamicallyDefined());
        this.wNumber.setText(Const.NVL((String)this.partitionSchema.getNumberOfPartitionsPerSlave(), (String)""));
        this.wName.setFocus();
    }

    private void refreshPartitions() {
        this.wPartitions.clearAll(false);
        List partitionIDs = this.partitionSchema.getPartitionIDs();
        for (int i = 0; i < partitionIDs.size(); ++i) {
            TableItem item = new TableItem(this.wPartitions.table, 0);
            item.setText(1, (String)partitionIDs.get(i));
        }
        this.wPartitions.removeEmptyRows();
        this.wPartitions.setRowNums();
        this.wPartitions.optWidth(true);
    }

    private void cancel() {
        this.originalSchema = null;
        this.dispose();
    }

    public void ok() {
        this.getInfo();
        this.originalSchema.setName(this.partitionSchema.getName());
        this.originalSchema.setPartitionIDs(this.partitionSchema.getPartitionIDs());
        this.originalSchema.setDynamicallyDefined(this.wDynamic.getSelection());
        this.originalSchema.setNumberOfPartitionsPerSlave(this.wNumber.getText());
        this.originalSchema.setChanged();
        this.ok = true;
        this.dispose();
    }

    private void getInfo() {
        this.partitionSchema.setName(this.wName.getText());
        ArrayList<String> parts = new ArrayList<String>();
        int nrNonEmptyPartitions = this.wPartitions.nrNonEmpty();
        for (int i = 0; i < nrNonEmptyPartitions; ++i) {
            parts.add(this.wPartitions.getNonEmpty(i).getText(1));
        }
        this.partitionSchema.setPartitionIDs(parts);
    }

    protected void importPartitions() {
        DatabaseMeta databaseMeta;
        PartitionDatabaseMeta[] partitioningInformation;
        EnterSelectionDialog dialog;
        String dbName;
        ArrayList<String> partitionedDatabaseNames = new ArrayList<String>();
        for (int i = 0; i < this.databases.size(); ++i) {
            DatabaseMeta databaseMeta2 = this.databases.get(i);
            if (!databaseMeta2.isPartitioned()) continue;
            partitionedDatabaseNames.add(databaseMeta2.getName());
        }
        String[] dbNames = partitionedDatabaseNames.toArray(new String[partitionedDatabaseNames.size()]);
        if (dbNames.length > 0 && (dbName = (dialog = new EnterSelectionDialog(this.shell, dbNames, BaseMessages.getString(PKG, (String)"PartitionSchema.SelectDatabase", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PartitionSchema.SelectPartitionnedDatabase", (String[])new String[0]))).open()) != null && (partitioningInformation = (databaseMeta = DatabaseMeta.findDatabase(this.databases, (String)dbName)).getPartitioningInformation()) != null) {
            this.wPartitions.clearAll(false);
            for (int i = 0; i < partitioningInformation.length; ++i) {
                PartitionDatabaseMeta meta = partitioningInformation[i];
                this.wPartitions.add(meta.getPartitionId());
            }
            this.wPartitions.removeEmptyRows();
            this.wPartitions.setRowNums();
            this.wPartitions.optWidth(true);
        }
    }
}

